#include "UG2_LIB.h"

void ug2_write_qarearchk (INT_ nbface,
                          INT_ nquad,
                          INT_3D * inibf,
                          INT_4D * iniq,
                          double qmin,
                          double qmin2,
                          DOUBLE_2D * x)
{

/*
 * Check tria/quad-face area-length to edge-length ratio function, q.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_write_qarearchk.c,v 1.1 2023/09/09 18:10:46 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX Text;

  INT_ i, i1, i2, i3, i4, n_q_min, n_q_min2;

  double q, q_avg, q_max, q_min, q_sum;

  ug_message ("");
  ug_message ("UG2      : Q AREA-LENGTH-RATIO CHECK");
  ug_message ("                                2");
  ug_message ("UG2      : Q = c * Area / sum( L  )");
  ug_message ("UG2      : 0 <= Q <= 1");

  if (nbface)
  {
    n_q_min = 0;
    n_q_min2 = 0;

    q_max = 0;
    q_min = 1;
    q_sum = 0;

    for (i = 1; i <= nbface; ++i)
    {
      i1 = inibf[i][0];
      i2 = inibf[i][1];
      i3 = inibf[i][2];

      q = ug2_tria_qarear (i1, i2, i3, x);

      q_max = MAX (q_max, q);
      q_min = MIN (q_min, q);
      q_sum = q_sum + q;

      if (q < qmin)
        ++n_q_min;

      if (q < qmin2)
        ++n_q_min2;
    }

    q_avg = q_sum / ((double) nbface);

    ug_message ("");
    snprintf (Text, sizeof(Text), "UG2      : No. Tria Faces    =%10i", (int) nbface);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG2      : Min, Max Q        =%10.3g%10.3g", q_min, q_max);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG2      : Average Q         =%10.3g", q_avg);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG2      : No. Q<%10.3g  =%10i", qmin, (int) n_q_min);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG2      : No. Q<%10.3g  =%10i", qmin2, (int) n_q_min2);
    ug_message (Text);
  }

  if (nquad)
  {
    n_q_min = 0;
    n_q_min2 = 0;

    q_max = 0;
    q_min = 1;
    q_sum = 0;

    for (i = 1; i <= nquad; ++i)
    {
      i1 = iniq[i][0];
      i2 = iniq[i][1];
      i3 = iniq[i][2];
      i4 = iniq[i][3];

      q = ug2_quad_qarear (i1, i2, i3, i4, x);

      q_max = MAX (q_max, q);
      q_min = MIN (q_min, q);
      q_sum = q_sum + q;

      if (q < qmin)
        ++n_q_min;

      if (q < qmin2)
        ++n_q_min2;
    }

    q_avg = q_sum / ((double) nquad);

    ug_message ("");
    snprintf (Text, sizeof(Text), "UG2      : No. Quad Faces    =%10i", (int) nquad);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG2      : Min, Max Q        =%10.3g%10.3g", q_min, q_max);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG2      : Average Q         =%10.3g", q_avg);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG2      : No. Q<%10.3g  =%10i", qmin, (int) n_q_min);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG2      : No. Q<%10.3g  =%10i", qmin2, (int) n_q_min2);
    ug_message (Text);
  }

  return;
}
