#include "UG2_LIB.h"

void ug2_write_edge_grid_error_file
 (char Case_Name[],
  INT_ Error_Flag_,
  INT_ Number_of_Bnd_Edges,
  INT_ Number_of_Nodes,
  INT_1D * Bnd_Edge_Error_Flag,
  INT_2D * Bnd_Edge_Connectivity,
  DOUBLE_2D * Coordinates)

{

/*
 * Write a UG2 boundary edge grid file with edges in error identified or a
 * UG2 boundary edge grid node error file with nodes in error listed.
 *
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_write_edge_grid_error_file.c,v 1.16 2022/11/21 00:11:08 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  FILE *Error_File;

  CHAR_UG_MAX drive, dname, fname, ext, File_Name, Text;
  CHAR_51 Name_Text;

  INT_ Error_Flag, Index, Max_Entries, New_Bnd_Edge_ID_Flag, Node_Index,
       Write_Flag;

  if (Error_Flag_ < 200000 || Error_Flag_ >= 300000)
    return;

  if (Bnd_Edge_Error_Flag[1] <= 0)
  {
    strcpy (File_Name, Case_Name);
    strcat (File_Name, ".FAIL.ugrid");

    ug_splitpath (File_Name, drive, dname, fname, ext);

    strcat (fname, ext);
    strcpy (Name_Text, "");
    strncat (Name_Text, fname, 50);

    snprintf (Text, sizeof(Text), "*** see UGRID boundary edge grid file %s ***", Name_Text);
    ug_error_message (Text);
    ug_error_message ("*** boundary edges that may be causing error have an ID of -1 ***");
    ug_error_message ("*** or are nearby those with an ID of -1 ***");

    Error_Flag = ug_backup_file (File_Name);

    Error_File = ug_fopen (File_Name, "w");

    if (Error_File == NULL)
    {
      snprintf (Text, sizeof(Text), "*** unable to open and write file %s ***", Name_Text);
      ug_error_message (Text);
      return;
    }

    Write_Flag = fprintf (Error_File, "%i 0 0 0 0 0 0\n", (int) Number_of_Nodes);

    if (Write_Flag < 0)
    {
      snprintf (Text, sizeof(Text), "*** error writing file %s ***", Name_Text);
      ug_error_message (Text);
      return;
    }

    for (Index = 1; Index <= Number_of_Nodes; ++Index)
    {
      Write_Flag = fprintf (Error_File, "%g %g 0.\n",
                            Coordinates[Index][0], Coordinates[Index][1]);
    }

    if (Write_Flag < 0)
    {
      snprintf (Text, sizeof(Text), "*** error writing file %s ***", Name_Text);
      ug_error_message (Text);
      return;
    }

    Write_Flag = fprintf (Error_File, "%i\n", (int) Number_of_Bnd_Edges);

    if (Write_Flag < 0)
    {
      snprintf (Text, sizeof(Text), "*** error writing file %s ***", Name_Text);
      ug_error_message (Text);
      return;
    }

    for (Index = 1; Index <= Number_of_Bnd_Edges; ++Index)
    {
      if (Bnd_Edge_Error_Flag[Index] < 0)
        New_Bnd_Edge_ID_Flag = -1;
      else
        New_Bnd_Edge_ID_Flag = 0;

      Write_Flag = fprintf (Error_File, "%i %i %i\n",
                               (int) Bnd_Edge_Connectivity[Index][0],
                               (int) Bnd_Edge_Connectivity[Index][1],
                               (int) New_Bnd_Edge_ID_Flag);
    }

    if (Write_Flag < 0)
    {
      snprintf (Text, sizeof(Text), "*** error writing file %s ***", Name_Text);
      ug_error_message (Text);
      return;
    }

    ug_fclose (Error_File);
  }

  else
  {
    strcpy (File_Name, Case_Name);
    strcat (File_Name, ".FAIL.node");

    ug_splitpath (File_Name, drive, dname, fname, ext);

    strcat (fname, ext);
    strcpy (Name_Text, "");
    strncat (Name_Text, fname, 50);

    snprintf (Text, sizeof(Text), "*** see file %s ***", Name_Text);
    ug_error_message (Text);
    ug_error_message ("*** this file contains a list of nodes which are not ***");
    ug_error_message ("*** included in the boundary edges ***");
    ug_error_message ("*** each line of the file contains the node index ***");
    ug_error_message ("*** followed by the coordinates ***");

    Error_Flag = ug_backup_file (File_Name);

    Error_File = ug_fopen (File_Name, "w");

    if (Error_File == NULL)
    {
      snprintf (Text, sizeof(Text), "*** unable to open and write file %s ***", Name_Text);
      ug_error_message (Text);
      return;
    }

    Max_Entries = MIN (Number_of_Nodes, Number_of_Bnd_Edges);

    for (Index = 1; Index <= Max_Entries; ++Index) 
    {
      Node_Index = Bnd_Edge_Error_Flag[Index];

      if (Node_Index > 0)
        Write_Flag = fprintf (Error_File, "%i %g %g\n",
                              (int) Node_Index,
                              Coordinates[Index][0],
                              Coordinates[Index][1]);
    }

    if (Write_Flag < 0)
    {
      snprintf (Text, sizeof(Text), "*** unable to write file %s ***", Name_Text);
      ug_error_message (Text);
      return;
    }

    ug_fclose (Error_File);
  }

  return;

}
