#include "UG2_LIB.h"

void ug2_write_angchk (INT_ nbface,
                       INT_ nquad,
                       INT_3D * inibf,
                       INT_4D * iniq,
                       double ang_qmin,
                       double ang_qmax,
                       double ang_qmax2,
                       DOUBLE_2D * x)
{

/*
 * Check boundary surface mesh face angles and generate output.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_write_angchk.c,v 1.1 2023/09/09 19:50:57 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  CHAR_UG_MAX Text;

  INT_ i, i1, i2, i3, i4, n_ang_qmin, n_ang_qmax, n_ang_qmax2;

  double ang_cnv, ang_max, ang_min, ang_mn, ang_mx, ang1, ang2, ang3, ang4,
         w1, w2, w3, w4;

  ang_cnv = 45.0 / atan (1.0);

  ug_message ("");
  ug_message ("UG2      : FACE ANGLE CHECK");

  n_ang_qmin = 0;
  n_ang_qmax = 0;
  n_ang_qmax2 = 0;

  ang_max = 0;
  ang_min = 180.0;

  for (i = 1; i <= nbface ; ++i)
  {
    i1 = inibf[i][0];
    i2 = inibf[i][1];
    i3 = inibf[i][2];

    ug2_tria_face_ang_w (i1, i2, i3, &w1, &w2, &w3, x);

    w1 = (w1 > 0) ? sqrt (w1): - sqrt (fabs (w1));
    w2 = (w2 > 0) ? sqrt (w2): - sqrt (fabs (w2));
    w3 = (w3 > 0) ? sqrt (w3): - sqrt (fabs (w3));

    ang1 = ang_cnv * acos (w1);
    ang2 = ang_cnv * acos (w2);
    ang3 = ang_cnv * acos (w3);

    ang_mx = MAX (ang1, ang2);
    ang_mx = MAX (ang_mx, ang3);

    ang_max = MAX (ang_max, ang_mx);

    ang_mn = MIN (ang1, ang2);
    ang_mn = MIN (ang_mn, ang3);

    ang_min = MIN (ang_min, ang_mn);

    if (ang_mx > ang_qmax)
      ++n_ang_qmax;

    if (ang_mn < ang_qmin)
      ++n_ang_qmin;

    if (ang_mx > ang_qmax2)
      ++n_ang_qmax2;
  }

  if (nbface)
  {
    ug_message ("");
    snprintf (Text, sizeof(Text), "UG2      : No. Tria Faces    =%10i", (int) nbface);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG2      : Min, Max Ang      =%10.4g%10.4g", ang_min, ang_max);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG2      : No. Angle<%5.1f   =%10i", ang_qmin, (int) n_ang_qmin);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG2      : No. Angle>%5.1f   =%10i", ang_qmax, (int) n_ang_qmax);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG2      : No. Angle>%5.1f   =%10i", ang_qmax2, (int) n_ang_qmax2);
    ug_message (Text);
  }

  n_ang_qmin = 0;
  n_ang_qmax = 0;
  n_ang_qmax2 = 0;

  ang_max = 0;
  ang_min = 180.0;

  for (i = 1; i <= nquad; ++i)
  {
    i1 = iniq[i][0];
    i2 = iniq[i][1];
    i3 = iniq[i][2];
    i4 = iniq[i][3];

    ug2_quad_face_ang_w (i1, i2, i3, i4, &w1, &w2, &w3, &w4, x);

    w1 = (w1 > 0) ? sqrt (w1): - sqrt (fabs (w1));
    w2 = (w2 > 0) ? sqrt (w2): - sqrt (fabs (w2));
    w3 = (w3 > 0) ? sqrt (w3): - sqrt (fabs (w3));
    w4 = (w4 > 0) ? sqrt (w4): - sqrt (fabs (w4));

    ang1 = ang_cnv * acos (w1);
    ang2 = ang_cnv * acos (w2);
    ang3 = ang_cnv * acos (w3);
    ang4 = ang_cnv * acos (w4);

    ang_mx = MAX (ang1, ang2);
    ang_mx = MAX (ang_mx, ang3);
    ang_mx = MAX (ang_mx, ang4);

    ang_max = MAX (ang_max, ang_mx);

    ang_mn = MIN (ang1, ang2);
    ang_mn = MIN (ang_mn, ang3);
    ang_mn = MIN (ang_mn, ang4);

    ang_min = MIN (ang_min, ang_mn);

    if (ang_mx > ang_qmax)
      ++n_ang_qmax;

    if (ang_mn < ang_qmin)
      ++n_ang_qmin;

    if (ang_mx > ang_qmax2)
      ++n_ang_qmax2;
  }

  if (nquad)
  {
    ug_message ("");
    snprintf (Text, sizeof(Text), "UG2      : No. Quad Faces    =%10i", (int) nquad);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG2      : Min, Max Ang      =%10.4g%10.4g", ang_min, ang_max);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG2      : No. Angle<%5.1f   =%10i", ang_qmin, (int) n_ang_qmin);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG2      : No. Angle>%5.1f   =%10i", ang_qmax, (int) n_ang_qmax);
    ug_message (Text);
    snprintf (Text, sizeof(Text), "UG2      : No. Angle>%5.1f   =%10i", ang_qmax2, (int) n_ang_qmax2);
    ug_message (Text);
  }

  return;
}
