#include "UG2_LIB.h"

void ug2_vsmth
 (INT_ nelem,
  INT_ nnode,
  INT_3D * ieliel,
  INT_3D * iniel,
  DOUBLE_1D * vsmth)

{

/*
 * Determine the smoothing map.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_vsmth.c,v 1.7 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ ielem, ielem1, ielem2, ielem3, inode, inode1, inode2, inode3;

  double dc0, dc1, dc1d2, vsmth1, vsmth2, vsmth3, vsmthm;

  dc0 = 0.0;
  dc1 = 1.0;
  dc1d2 = 0.5;

  for (inode = 1; inode <= nnode; ++inode)
  {
    vsmth[inode] = dc1;
  }

  for (ielem = 1; ielem <= nelem; ++ielem)
  {
    ielem1 = ieliel[ielem][0];
    ielem2 = ieliel[ielem][1];
    ielem3 = ieliel[ielem][2];

    inode1 = iniel[ielem][0];
    inode2 = iniel[ielem][1];
    inode3 = iniel[ielem][2];

    if (ielem1 <= 0)
    {
      vsmth[inode2] = dc0;
      vsmth[inode3] = dc0;
    }

    if (ielem2 <= 0)
    {
      vsmth[inode1] = dc0;
      vsmth[inode3] = dc0;
    }

    if (ielem3 <= 0)
    {
      vsmth[inode1] = dc0;
      vsmth[inode2] = dc0;
    }
  }

  for (ielem = 1; ielem <= nelem; ++ielem)
  {
    inode1 = iniel[ielem][0];
    inode2 = iniel[ielem][1];
    inode3 = iniel[ielem][2];

    vsmth1 = vsmth[inode1];
    vsmth2 = vsmth[inode2];
    vsmth3 = vsmth[inode3];

    vsmthm = MIN (vsmth1, vsmth2);
    vsmthm = MIN (vsmthm, vsmth3);

    if (vsmthm == dc0)
    {
      if (vsmth1 == dc1) vsmth[inode1] = dc1d2;
      if (vsmth2 == dc1) vsmth[inode2] = dc1d2;
      if (vsmth3 == dc1) vsmth[inode3] = dc1d2;
    }
  }

  return;

}
