#include "UG2_LIB.h"

INT_ ug2_srch
 (INT_ *ielem,
  INT_ isrch,
  INT_ mglobal,
  INT_ nelem,
  INT_3D * ieliel,
  INT_3D * iniel,
  INT_1D * msrch,
  double smin,
  double smin2,
  double x01,
  double x02,
  double *s1,
  double *s2,
  double *s3,
  DOUBLE_2D * x)

{

/*
 * Find the element that contains the node x01,x02.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_srch.c,v 1.25 2022/07/01 17:56:57 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ ierr, inode1, inode2, inode3, isave, jelem, kelem, mfound;

  double area, area1, area1j, area1k, area2, area2j, area2k, area3, area3j,
         area3k, areamin, dc0, dc1, dx101, dx102, dx201, dx202, dx301, dx302,
         smin2m, smin3m, w, x11, x12, x21, x22, x31, x32;

  dc0 = 0.0;
  dc1 = 1.0;

  if (isrch == 1)
    ug_set_int (1, nelem, 0, msrch);

  isave = *ielem;

  jelem = *ielem;

  do
  {
    *ielem = jelem;

    msrch[*ielem] = isrch;

    inode1 = iniel[*ielem][0];
    inode2 = iniel[*ielem][1];
    inode3 = iniel[*ielem][2];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x21 = x[inode2][0];
    x22 = x[inode2][1];
    x31 = x[inode3][0];
    x32 = x[inode3][1];

    dx101 = x11 - x01;
    dx102 = x12 - x02;
    dx201 = x21 - x01;
    dx202 = x22 - x02;
    dx301 = x31 - x01;
    dx302 = x32 - x02;

    area1 = dx201 * dx302 - dx202 * dx301;
    area2 = dx301 * dx102 - dx302 * dx101;
    area3 = dx101 * dx202 - dx102 * dx201;

    area = area1 + area2 + area3;

    if (area < dc0)
    {
      area = -area;

      area1 = -area1;
      area2 = -area2;
      area3 = -area3;
    }

    areamin = MIN (area1, area2);
    areamin = MIN (area3, areamin);

    w = areamin + smin * area;

    mfound = (w >= dc0) ? 1 : -2;

    if (mfound < -1 && area1 < dc0)
    {
      jelem = ieliel[*ielem][0];

      mfound = (jelem > 0) ? ((msrch[jelem] != isrch) ? -1 : -2) : -3;
    }

    if (mfound < -1 && area2 < dc0)
    {
      jelem = ieliel[*ielem][1];

      mfound = (jelem > 0) ? ((msrch[jelem] != isrch) ? -1 : -2) : -3;
    }

    if (mfound < -1 && area3 < dc0)
    {
      jelem = ieliel[*ielem][2];

      mfound = (jelem > 0) ? ((msrch[jelem] != isrch) ? -1 : -2) : -3;
    }
  }
  while (mfound == -1);

  if (mfound == -3)
  {
    w = areamin + smin2 * area;

    mfound = (w >= dc0) ? 1 : -2;
  }

  if (mglobal >= 1 && mfound == -2)
  {
    jelem = 0;
    kelem = 0;

    smin2m = smin2;
    smin3m = dc0;

    *ielem = 0;

    do
    {
      ++(*ielem);

      if (msrch[*ielem] != isrch)
      {
        msrch[*ielem] = isrch;

        inode1 = iniel[*ielem][0];
        inode2 = iniel[*ielem][1];
        inode3 = iniel[*ielem][2];

        x11 = x[inode1][0];
        x12 = x[inode1][1];
        x21 = x[inode2][0];
        x22 = x[inode2][1];
        x31 = x[inode3][0];
        x32 = x[inode3][1];

        dx101 = x11 - x01;
        dx102 = x12 - x02;
        dx201 = x21 - x01;
        dx202 = x22 - x02;
        dx301 = x31 - x01;
        dx302 = x32 - x02;

        area1 = dx201 * dx302 - dx202 * dx301;
        area2 = dx301 * dx102 - dx302 * dx101;
        area3 = dx101 * dx202 - dx102 * dx201;

        area = area1 + area2 + area3;

        if (area < dc0)
        {
          area = -area;

          area1 = -area1;
          area2 = -area2;
          area3 = -area3;
        }

        areamin = MIN (area1, area2);
        areamin = MIN (area3, areamin);

        w = areamin + smin * area;

        if (w >= dc0)
          mfound = 1;

        else
        {
          if (smin2 > smin)
          {
            w = areamin + smin2 * area;

            if (w >= dc0)
            {
              w = areamin + smin2m * area;

              if (((area1 == areamin && ieliel[*ielem][0] <= 0) ||
                   (area2 == areamin && ieliel[*ielem][1] <= 0) ||
                   (area3 == areamin && ieliel[*ielem][2] <= 0)) && w >= dc0)
              {
                jelem = *ielem;

                area1j = area1;
                area2j = area2;
                area3j = area3;

                smin2m = fabs (areamin) / area;
              }
            }
          }

          if (mglobal == 2 && areamin < dc0 && w < dc0)
          {
            w = (smin3m > dc0) ? areamin + smin3m * area: dc0;

            if (((area1 == areamin && ieliel[*ielem][0] <= 0) ||
                 (area2 == areamin && ieliel[*ielem][1] <= 0) ||
                 (area3 == areamin && ieliel[*ielem][2] <= 0)) && w >= dc0)
            {
              kelem = *ielem;

              area1k = area1;
              area2k = area2;
              area3k = area3;

              smin3m = fabs (areamin) / area;
            }
          }
        }
      }
    }
    while (*ielem < nelem && mfound == -2);

    if (mfound == -2 && jelem > 0)
    {
      mfound = 1;

      *ielem = jelem;

      area1 = area1j;
      area2 = area2j;
      area3 = area3j;

      area = area1 + area2 + area3;
    }

    else if (mfound == -2 && kelem > 0)
    {
      mfound = 2;

      *ielem = kelem;

      area1 = area1k;
      area2 = area2k;
      area3 = area3k;

      area = area1 + area2 + area3;
    }
  }

  if (mfound >= 1)
  {
    w = dc1 / area;

    *s1 = w * area1;
    *s2 = w * area2;
    *s3 = w * area3;
  }
  else
    *ielem = isave;

  ierr = (mfound == 1) ?  0:
         (mfound == 2) ? -1: 1;

  return (ierr);

}
