#include "UG2_LIB.h"

void ug2_smth
 (INT_ mmsg,
  INT_ nelem,
  INT_ nnode,
  INT_ nsmth,
  INT_3D * iniel,
  double csmth,
  double tol,
  DOUBLE_1D * vsmth,
  DOUBLE_2D * x,
  DOUBLE_1D * wsum,
  DOUBLE_2D * xsave,
  DOUBLE_1D * xsum)

{

/*
 * Smooth the grid coordinates using optimal placement or centroid averaging.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_smth.c,v 1.9 2022/11/21 00:11:08 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  CHAR_UG_MAX Text;

  INT_ ielem, igeom, inode, inode1, inode2, inode3, ismth, ismthr, msmthr,
       nsmthrm;

  double area, areatol, csmthi, csmthr, dc0, dc1, dc3, dx, dx1, dx2, dx211,
         dx212, dx311, dx312, x11, x12, x1i, x1max, x1min, x21, x22, x2i, x2max,
         x2min, x31, x32, x3i, xsumi;

  dc0 = 0.0;
  dc1 = 1.0;
  dc3 = 3.0;

  csmthr = 0.4;

  nsmthrm = 2;

  if (nsmth == 0 || csmth <= dc0)
    return;

  if (mmsg == 2)
  {
    snprintf (Text, sizeof(Text), " Smoothing          : Nodes, Elements   =%10i%10i", (int) nnode, (int) nelem);
    ug_message (Text);
  }

  for (inode = 1; inode <= nnode; ++inode)
  {
    xsave[inode][0] = x[inode][0];
    xsave[inode][1] = x[inode][1];
  }

  ismthr = 0;

  do
  {
    csmthi = csmth;

    for (inode = 1; inode <= nnode; ++inode)
    {
      wsum[inode] = dc0;
    }

    for (ielem = 1; ielem <= nelem; ++ielem)
    {
      inode1 = iniel[ielem][0];
      inode2 = iniel[ielem][1];
      inode3 = iniel[ielem][2];

      wsum[inode1] = wsum[inode1] + dc3;
      wsum[inode2] = wsum[inode2] + dc3;
      wsum[inode3] = wsum[inode3] + dc3;
    }

    for (inode = 1; inode <= nnode; ++inode)
    {
      wsum[inode] = csmthi * vsmth[inode] / wsum[inode];
    }

    for (ismth = 1; ismth <= nsmth; ++ismth)
    {
      for (igeom = 0; igeom <= 1; ++igeom)
      {
        for (inode = 1; inode <= nnode; ++inode)
        {
          xsum[inode] = dc0;
        }

        for (ielem = 1; ielem <= nelem; ++ielem)
        {
          inode1 = iniel[ielem][0];
          inode2 = iniel[ielem][1];
          inode3 = iniel[ielem][2];

          x1i = x[inode1][igeom];
          x2i = x[inode2][igeom];
          x3i = x[inode3][igeom];

          xsumi = x1i + x2i + x3i;

          xsum[inode1] = xsum[inode1] + xsumi;
          xsum[inode2] = xsum[inode2] + xsumi;
          xsum[inode3] = xsum[inode3] + xsumi;
        }

        for (inode = 1; inode <= nnode; ++inode)
        {
          x[inode][igeom] = (dc1 - csmthi * vsmth[inode]) * x[inode][igeom]
                          + wsum[inode] * xsum[inode];
        }
      }
    }

    ielem = 1;

    do
    {
      inode1 = iniel[ielem][0];
      inode2 = iniel[ielem][1];
      inode3 = iniel[ielem][2];

      x11 = x[inode1][0];
      x12 = x[inode1][1];
      x21 = x[inode2][0];
      x22 = x[inode2][1];
      x31 = x[inode3][0];
      x32 = x[inode3][1];

      x1max = MAX (x11, x21);
      x1max = MAX (x31, x1max);
      x2max = MAX (x12, x22);
      x2max = MAX (x32, x2max);
      x1min = MIN (x11, x21);
      x1min = MIN (x31, x1min);
      x2min = MIN (x12, x22);
      x2min = MIN (x32, x2min);

      dx1 = x1max - x1min;
      dx2 = x2max - x2min;

      dx = MAX (dx1, dx2);

      areatol = tol * dx * dx;

      dx211 = x21 - x11;
      dx212 = x22 - x12;
      dx311 = x31 - x11;
      dx312 = x32 - x12;

      area = dx211 * dx312 - dx212 * dx311;

      ++ielem;
    }
    while (ielem <= nelem && area >= areatol);

    if (area < areatol)
    {
      ++ismthr;

      csmthi = csmthr * csmthi;

      for (inode = 1; inode <= nnode; ++inode)
      {
        x[inode][0] = xsave[inode][0];
        x[inode][1] = xsave[inode][1];
      }

      if (mmsg == 2)
      {
        snprintf (Text, sizeof(Text), " Smoothing          : Retry");
        ug_message (Text);
      }

      msmthr = 1;
    }
    else
      msmthr = 0;
  }
  while (ismthr < nsmthrm && msmthr == 1);

  if (msmthr == 1 && mmsg == 2)
  {
    snprintf (Text, sizeof(Text), " Smoothing          : Turned OFF");
    ug_message (Text);
  }

  return;

}
