#include "UG2_LIB.h"

INT_ ug2_sign
 (INT_ nelem,
  INT_3D * iniel,
  DOUBLE_2D * x)

{

/*
 * Check the element connectivity ordering for RH rule.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_sign.c,v 1.14 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ ielem, inode1, inode2, inode3;

  double area, areamax, areamin, dc0, dx211, dx212, dx311, dx312, sign, x11,
         x12, x21, x22, x31, x32;

  dc0 = 0.0;

  ielem = 1;

  inode1 = iniel[ielem][0];
  inode2 = iniel[ielem][1];
  inode3 = iniel[ielem][2];

  x11 = x[inode1][0];
  x12 = x[inode1][1];
  x21 = x[inode2][0];
  x22 = x[inode2][1];
  x31 = x[inode3][0];
  x32 = x[inode3][1];

  dx211 = x21 - x11;
  dx212 = x22 - x12;
  dx311 = x31 - x11;
  dx312 = x32 - x12;

  
  area = dx211 * dx312 - dx212 * dx311;

  areamax = area;
  areamin = area;

  for (ielem = 2; ielem <= nelem; ++ielem)
  {
    inode1 = iniel[ielem][0];
    inode2 = iniel[ielem][1];
    inode3 = iniel[ielem][2];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x21 = x[inode2][0];
    x22 = x[inode2][1];
    x31 = x[inode3][0];
    x32 = x[inode3][1];

    dx211 = x21 - x11;
    dx212 = x22 - x12;
    dx311 = x31 - x11;
    dx312 = x32 - x12;

    area = dx211 * dx312 - dx212 * dx311;

    areamax = MAX (areamax, area);
    areamin = MIN (areamin, area);
  }

  sign = areamax * areamin;

  if (sign <= dc0)
  {
    ug_error_message ("*** ERROR 216 : found element with negative area ***");
    return (216);
  }


  if (areamax < dc0)
  {
    for (ielem = 1; ielem <= nelem; ++ielem)
    {
      inode1 = iniel[ielem][0];
      inode3 = iniel[ielem][2];

      iniel[ielem][0] = inode3;
      iniel[ielem][2] = inode1;
    }
  }

  return (0);

}
