#include "UG2_LIB.h"

static void ug2_reorderb0
 (INT_ nnode,
  INT_ *nnodeb,
  INT_ nbedge,
  INT_ nelem,
  INT_ nquad,
  INT_2D * inibe,
  INT_3D * iniel,
  INT_4D * iniq,
  INT_1D * jnin,
  INT_1D * mn,
  DOUBLE_1D * df,
  DOUBLE_3D * met,
  DOUBLE_2D * x);

void ug2_reorderb
 (INT_ nnode,
  INT_ *nnodeb,
  INT_ nbedge,
  INT_ nelem,
  INT_ nquad,
  INT_2D * inibe,
  INT_3D * iniel,
  INT_4D * iniq,
  INT_1D * jnin,
  INT_1D * mn,
  DOUBLE_2D * x)
{
  ug2_reorderb0 (nnode, nnodeb, nbedge, nelem, nquad,
                 inibe, iniel, iniq, jnin, mn, NULL, NULL, x);
  return;
}

INT_ ug2_reorderb2
 (INT_ nnode,
  INT_ nbedge,
  INT_ nelem,
  INT_ nquad,
  INT_2D * inibe,
  INT_3D * iniel,
  INT_4D * iniq,
  DOUBLE_1D * df,
  DOUBLE_3D * met,
  DOUBLE_2D * x)
{
  INT_1D *jnin = NULL;
  INT_1D *mn = NULL;

  INT_ ierr = 0;;
  INT_ nnodeb = 0;

  jnin = (INT_1D *) ug_malloc (&ierr, (nnode+1) * sizeof (INT_1D));
  mn = (INT_1D *) ug_malloc (&ierr, (nnode+1) * sizeof (INT_1D));

  if (ierr) {
    ug_free (jnin);
    ug_free (mn);
    ug_error_message ("*** ERROR 100208 : unable to allocate required memory ***");
    return 100208;
  }

  ug2_reorderb0 (nnode, &nnodeb, nbedge, nelem, nquad,
                 inibe, iniel, iniq, jnin, mn, df, met, x);

  ug_free (jnin);
  ug_free (mn);

  return 0;
}

static void ug2_reorderb0
 (INT_ nnode,
  INT_ *nnodeb,
  INT_ nbedge,
  INT_ nelem,
  INT_ nquad,
  INT_2D * inibe,
  INT_3D * iniel,
  INT_4D * iniq,
  INT_1D * jnin,
  INT_1D * mn,
  DOUBLE_1D * df,
  DOUBLE_3D * met,
  DOUBLE_2D * x)

{

/*
 * Re-orders nodes so that all boundary nodes are first in the ordering.
 *
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_reorderb.c,v 1.9 2024/04/12 06:51:46 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ found, ibedge, ielem, inode, inode0, inode1, inode2, inode3, inode4,
       iquad, jnode;

  double df0, met1, met2, met3, x1, x2;

  for (inode = 1; inode <= nnode; ++inode)
  {
    mn[inode] = 1;
  }

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    inode1 = inibe[ibedge][0];
    inode2 = inibe[ibedge][1];

    mn[inode1] = 0;
    mn[inode2] = 0;
  }

  inode0 = 0;

  *nnodeb = 0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    if (mn[inode] == 0)
      ++(*nnodeb);
    else if (inode0 == 0)
      inode0 = inode;
  }

  if (inode0 == 0)
    return;

  for (inode = 1; inode <= nnode; ++inode)
  {
    jnin[inode] = inode;
  }

  found = 1;

  inode2 = nnode;

  inode = inode0;

  do
  {
    if (mn[inode])
    {
      found = 0;

      if (inode2 > inode)
      {
        jnode = inode2;

        do
        {
          if (mn[jnode] == 0)
            found = 1;

          --jnode;
        }
        while (jnode > inode && found == 0);

        if (found == 1)
        {
          ++jnode;

          jnin[inode] = jnode;
          jnin[jnode] = inode;

          inode2 = jnode - 1;
        }
      }
    }

    ++inode;
  }
  while (inode <= nnode && found == 1);

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    inode1 = inibe[ibedge][0];
    inode2 = inibe[ibedge][1];

    inibe[ibedge][0] = jnin[inode1];
    inibe[ibedge][1] = jnin[inode2];
  }

  for (ielem = 1; ielem <= nelem; ++ielem)
  {
    inode1 = iniel[ielem][0];
    inode2 = iniel[ielem][1];
    inode3 = iniel[ielem][2];

    iniel[ielem][0] = jnin[inode1];
    iniel[ielem][1] = jnin[inode2];
    iniel[ielem][2] = jnin[inode3];
  }

  for (iquad = 1; iquad <= nquad; ++iquad)
  {
    inode1 = iniq[iquad][0];
    inode2 = iniq[iquad][1];
    inode3 = iniq[iquad][2];
    inode4 = iniq[iquad][3];

    iniq[iquad][0] = jnin[inode1];
    iniq[iquad][1] = jnin[inode2];
    iniq[iquad][2] = jnin[inode3];
    iniq[iquad][3] = jnin[inode4];
  }

  if (df)
  {
    for (inode = 1; inode <= nnode; ++inode)
    {
      jnode = jnin[inode];

      if (jnode > inode)
      {
        df0 = df[inode];

        df[inode] = df[jnode];

        df[jnode] = df0;
      }
    }
  }

  if (met)
  {
    for (inode = 1; inode <= nnode; ++inode)
    {
      jnode = jnin[inode];

      if (jnode > inode)
      {
        met1 = met[inode][0];
        met2 = met[inode][1];
        met3 = met[inode][2];

        met[inode][0] = met[jnode][0];
        met[inode][1] = met[jnode][1];
        met[inode][2] = met[jnode][2];

        met[jnode][0] = met1;
        met[jnode][1] = met2;
        met[jnode][2] = met3;
      }
    }
  }

  for (inode = 1; inode <= nnode; ++inode)
  {
    jnode = jnin[inode];

    if (jnode > inode)
    {
      x1 = x[inode][0];
      x2 = x[inode][1];

      x[inode][0] = x[jnode][0];
      x[inode][1] = x[jnode][1];

      x[jnode][0] = x1;
      x[jnode][1] = x2;
    }
  }

  return;

}
