#include "UG2_LIB.h"

/*
 * Read and write grid data from a MESH file using external routines.
 * 
 * UG3 LIB : Unstructured Grid - General Purpose Routine Library
 * 3D Version : $Id: ug2_read_write_mesh.c,v 1.3 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

INT_ (*ext_ug2_read_mesh) (char[],
                           INT_,
                           INT_ *,
                           INT_ *,
                           INT_ *,
                           INT_ *,
                           INT_ *,
                           INT_1D *,
                           INT_2D *,
                           INT_1D *,
                           INT_4D *,
                           INT_3D *,
                           DOUBLE_2D *) = 0;

INT_ (*ext_ug2_write_mesh) (char[],
                            INT_,
                            INT_,
                            INT_,
                            INT_,
                            INT_1D *,
                            INT_2D *,
                            INT_1D *,
                            INT_4D *,
                            INT_3D *,
                            DOUBLE_2D *) = 0;

void ug2_check_read_write_mesh (INT_ *check_rmesh,
                                INT_ *check_wmesh)
{
  *check_rmesh = (ext_ug2_read_mesh) ? 1: 0;
  *check_wmesh = (ext_ug2_write_mesh) ? 1: 0;
  return;
}

INT_ ug2_read_mesh (char File_Name[],
                    INT_ Read_Task_Flag,
                    INT_ *Number_of_Bnd_Nodes,
                    INT_ *Number_of_Nodes,
                    INT_ *Number_of_Bnd_Edges,
                    INT_ *Number_of_Quads,
                    INT_ *Number_of_Trias,
                    INT_1D * ID_Flag,
                    INT_2D * Bnd_Edge_Connectivity,
                    INT_1D * Face_ID_Flag,
                    INT_4D * Quad_Connectivity,
                    INT_3D * Tria_Connectivity,
                    DOUBLE_2D * Coordinates)
{
  INT_ Error_Flag;

  if (ext_ug2_read_mesh)
    Error_Flag = (*ext_ug2_read_mesh) (File_Name,
                                       Read_Task_Flag,
                                       Number_of_Bnd_Nodes,
                                       Number_of_Nodes,
                                       Number_of_Bnd_Edges,
                                       Number_of_Quads,
                                       Number_of_Trias,
                                       ID_Flag,
                                       Bnd_Edge_Connectivity,
                                       Face_ID_Flag,
                                       Quad_Connectivity,
                                       Tria_Connectivity,
                                       Coordinates);
  else
  {
    ug_error_message ("*** ERROR : MESH grid file type is not available ***");
    return (1);
  }

  return (Error_Flag);
}

INT_ ug2_write_mesh (char File_Name[],
                     INT_ Number_of_Nodes,
                     INT_ Number_of_Bnd_Edges,
                     INT_ Number_of_Quads,
                     INT_ Number_of_Trias,
                     INT_1D * ID_Flag,
                     INT_2D * Bnd_Edge_Connectivity,
                     INT_1D * Face_ID_Flag,
                     INT_4D * Quad_Connectivity,
                     INT_3D * Tria_Connectivity,
                     DOUBLE_2D * Coordinates)
{
  INT_ Error_Flag;

  if (ext_ug2_write_mesh)
    Error_Flag = (*ext_ug2_write_mesh) (File_Name,
                                        Number_of_Nodes,
                                        Number_of_Bnd_Edges,
                                        Number_of_Quads,
                                        Number_of_Trias,
                                        ID_Flag,
                                        Bnd_Edge_Connectivity,
                                        Face_ID_Flag,
                                        Quad_Connectivity,
                                        Tria_Connectivity,
                                        Coordinates);
  else
  {
    ug_error_message ("*** ERROR : MESH grid file type is not available ***");
    return (1);
  }

  return (Error_Flag);
}

// register names of external mesh library routines

void ug2_mesh_register_read_grid (INT_ (*ext_routine) (char[],
                                                       INT_,
                                                       INT_ *,
                                                       INT_ *,
                                                       INT_ *,
                                                       INT_ *,
                                                       INT_ *,
                                                       INT_1D *,
                                                       INT_2D *,
                                                       INT_1D *,
                                                       INT_4D *,
                                                       INT_3D *,
                                                       DOUBLE_2D *))
{
  ext_ug2_read_mesh = ext_routine;
  return;
}

void ug2_mesh_register_write_grid (INT_ (*ext_routine) (char[],
                                                        INT_,
                                                        INT_,
                                                        INT_,
                                                        INT_,
                                                        INT_1D *,
                                                        INT_2D *,
                                                        INT_1D *,
                                                        INT_4D *,
                                                        INT_3D *,
                                                        DOUBLE_2D *))
{
  ext_ug2_write_mesh = ext_routine;
  return;
}
