#include "UG2_LIB.h"

INT_ ug2_qtria
 (INT_ *nelem,
  INT_ *nquad,
  INT_3D ** iniel_ptr,
  INT_4D * iniq,
  DOUBLE_2D * x)

{

/*
 * Replace quad faces with tria faces.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_qtria.c,v 1.7 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_3D *iniel;

  INT_ ierr, ielem, inode1, inode2, inode3, inode4, iquad, jnode1, jnode2,
       jnode3, jnode4, nelemm;

  double a123, a124, a143, a243, dc0, dw, dwmin, dx211, dx212, dx311, dx312,
         dx321, dx322, dx411, dx412, dx421, dx422, dx431, dx432, w1, w123, w124,
         w143, w1min, w243, w2min, x11, x12, x21, x22, x31, x32, x41, x42;

  dc0 = 0.0;

  dwmin = 0.001;

  if (*nquad == 0)
    return (0);

  nelemm = *nelem + (*nquad) + (*nquad);

  ierr = 0;

  *iniel_ptr = (INT_3D *) ug_realloc (&ierr, *iniel_ptr,
                                      (nelemm+1) * sizeof (INT_3D));

  if (ierr > 0)
  {
    ug_error_message ("*** ERROR 100200 : unable to allocate required memory ***");
    return (100200);
  }

  iniel = *iniel_ptr;

  ielem = *nelem;

  for (iquad = 1; iquad <= *nquad; ++iquad)
  {
    inode1 = iniq[iquad][0];
    inode2 = iniq[iquad][1];
    inode3 = iniq[iquad][3];
    inode4 = iniq[iquad][2];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x21 = x[inode2][0];
    x22 = x[inode2][1];
    x31 = x[inode3][0];
    x32 = x[inode3][1];
    x41 = x[inode4][0];
    x42 = x[inode4][1];

    dx211 = x21 - x11;
    dx212 = x22 - x12;
    dx311 = x31 - x11;
    dx312 = x32 - x12;
    dx321 = x31 - x21;
    dx322 = x32 - x22;
    dx411 = x41 - x11;
    dx412 = x42 - x12;
    dx421 = x41 - x21;
    dx422 = x42 - x22;
    dx431 = x41 - x31;
    dx432 = x42 - x32;

    a124 = dx211 * dx412 - dx212 * dx411;
    a143 = dx411 * dx312 - dx412 * dx311;
    a123 = dx211 * dx312 - dx212 * dx311;
    a243 = dx421 * dx322 - dx422 * dx321;

    w123 = (  dx211 * dx311 + dx212 * dx312) / a123;
    w243 = (  dx431 * dx421 + dx432 * dx422) / a243;
    w124 = (- dx211 * dx421 - dx212 * dx422) / a124;
    w143 = (- dx431 * dx311 - dx432 * dx312) / a143;

    w1min = MIN (w123, w243);
    w2min = MIN (w124, w143); 

    dw = w2min - w1min;

    w1 = a123 * a243;

    if (dw < dwmin && w1 >= dc0)
    {
      jnode1 = inode1;
      jnode2 = inode2;
      jnode3 = inode3;
      jnode4 = inode4;
    }
    else
    {
      jnode1 = inode2;
      jnode2 = inode4;
      jnode3 = inode1;
      jnode4 = inode3;
    }

    ++ielem;

    iniel[ielem][0] = jnode1;
    iniel[ielem][1] = jnode2;
    iniel[ielem][2] = jnode3;

    ++ielem;

    iniel[ielem][0] = jnode2;
    iniel[ielem][1] = jnode4;
    iniel[ielem][2] = jnode3;
  }

  *nelem = nelemm;

  *nquad = 0;

  return (0);

}
