#include "UG2_LIB.h"

/*
 * UG2 LIB : Unstructured Grid - General Purpose Routine Lirary
 * 2D Version : $Id: ug2_qchk.c,v 1.5 2023/09/09 19:55:11 marcum Exp $
 * Copyright 1994-2023, David L. Marcum
 */

INT_ ug2_qchk (int argc,
                char *argv[],
                INT_ nbface,
                INT_ nquad,
                INT_3D * inibf,
                INT_4D * iniq,
                DOUBLE_2D * x)
{
  // Check and output mesh quality information.

  UG_Param_Struct * Param_Struct_Ptr;

  INT_ ierr;

  // malloc and set parameter structure arrays

  ierr = ug_malloc_param (&Param_Struct_Ptr);

  if (ierr == 0)
    ierr = ug2_qchk_initialize_param (Param_Struct_Ptr);

  if (ierr == 0)
    ug_set_params_from_arg (argv, argc, 1, 0, Param_Struct_Ptr);

  // check and output mesh quality information

  if (ierr == 0)
    ug2_qchk2 (nbface, nquad, inibf, iniq, x, Param_Struct_Ptr);

  ug_free_param (Param_Struct_Ptr);

  return ierr;
}

void ug2_qchk2 (INT_ nbface,
                INT_ nquad,
                INT_3D * inibf,
                INT_4D * iniq,
                DOUBLE_2D * x,
                UG_Param_Struct * Param_Struct_Ptr)
{
  // Check and output mesh quality information.

  INT_ iget;
  INT_ mqchk = 1;

  double ang_qmax, ang_qmin, ang_qmax2, qarear_qmin, qarear_qmin2;

  // get parameters

  iget = ug_get_int_param ("mqchk", &mqchk, Param_Struct_Ptr);

  iget = ug_get_double_param ("ang_qmax", &ang_qmax, Param_Struct_Ptr);
  iget = ug_get_double_param ("ang_qmin", &ang_qmin, Param_Struct_Ptr);
  iget = ug_get_double_param ("ang_qmax2", &ang_qmax2, Param_Struct_Ptr);
  iget = ug_get_double_param ("qarear_qmin", &qarear_qmin, Param_Struct_Ptr);
  iget = ug_get_double_param ("qarear_qmin2", &qarear_qmin2, Param_Struct_Ptr);

  if (mqchk == 0)
    return;

  // check and output face angles

  ug2_write_angchk (nbface, nquad, inibf, iniq,
                    ang_qmin, ang_qmax, ang_qmax2, x);

  // check and output face area-length to edge-length ratios

  ug2_write_qarearchk (nbface, nquad, inibf, iniq,
                       qarear_qmin, qarear_qmin2, x);

  return;
}
