#include "UG2_LIB.h"

/*
 * Determine face quality measure functions.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_qarear.c,v 1.1 2023/09/09 18:10:46 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

double ug2_qarear (double x11,
                   double x12,
                   double x21,
                   double x22,
                   double x31,
                   double x32)
{

  // Determine the tria area-length to edge-length ratio function, q.

  double area, cq,
         dx211, dx212,
         dx311, dx312,
         dx321, dx322,
         lsum, q;

  cq = 2.0 * sqrt (3.0);

  dx211 = x21 - x11;
  dx212 = x22 - x12;
  dx311 = x31 - x11;
  dx312 = x32 - x12;
  dx321 = x31 - x21;
  dx322 = x32 - x22;

  lsum = dx211 * dx211 + dx212 * dx212
       + dx321 * dx321 + dx322 * dx322
       + dx311 * dx311 + dx312 * dx312;

  area = dx211 * dx312 - dx212 * dx311;

  q = cq * area / lsum;

  return (q);
}

double ug2_tria_qarear (INT_ inode1,
                        INT_ inode2,
                        INT_ inode3,
                        DOUBLE_2D * x)
{
  // Determine the tria area-length to edge-length ratio function, q.

  return (ug2_qarear (x[inode1][0], x[inode1][1],
                      x[inode2][0], x[inode2][1],
                      x[inode3][0], x[inode3][1]));
}

double ug2_quad_qarear (INT_ inode1,
                        INT_ inode2,
                        INT_ inode3,
                        INT_ inode4,
                        DOUBLE_2D * x)
{

  // Determine the quad area-length to edge-length ratio function, q.

  double area, cq,
         dx211, dx212,
         dx321, dx322,
         dx431, dx432,
         dx411, dx412,
         lsum, q,
         x11, x12,
         x21, x22,
         x31, x32,
         x41, x42;

  cq = 2.0;

  x11 = x[inode1][0];
  x12 = x[inode1][1];
  x21 = x[inode2][0];
  x22 = x[inode2][1];
  x31 = x[inode3][0];
  x32 = x[inode3][1];
  x41 = x[inode4][0];
  x42 = x[inode4][1];

  dx211 = x21 - x11;
  dx212 = x22 - x12;
  dx321 = x31 - x21;
  dx322 = x32 - x22;
  dx431 = x41 - x31;
  dx432 = x42 - x32;
  dx411 = x41 - x11;
  dx412 = x42 - x12;

  lsum = dx211 * dx211 + dx212 * dx212
       + dx321 * dx321 + dx322 * dx322
       + dx431 * dx431 + dx432 * dx432
       + dx411 * dx411 + dx412 * dx412;

  area = dx211 * dx412 - dx212 * dx411
       + dx321 * dx432 - dx322 * dx431;

  q = cq * area / lsum;

  return (q);
}
