#include "UG2_LIB.h"

void ug2_nnodeb
 (INT_ nbedge,
  INT_ *nnodeb,
  INT_2D * inibe)

{

/*
 * Determine the maximum node index on the boundary surface.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_nnodeb.c,v 1.7 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ ibedge, inode1, inode2;

  *nnodeb = 0;

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    inode1 = inibe[ibedge][0];
    inode2 = inibe[ibedge][1];

    *nnodeb = MAX (inode1, *nnodeb);
    *nnodeb = MAX (inode2, *nnodeb);
  }

  return;

}
