#include "UG2_LIB.h"

INT_ ug2_nelem_est (INT_ mmsg,
                    INT_ nelem,
                    INT_3D * iniel,
                    DOUBLE_1D * df,
                    DOUBLE_2D * x)
{

/*
 * Estimate the total number of elements that will be generated.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id
 * Copyright 1994-2020, David L. Marcum
 */

  CHAR_UG_MAX Text;

  INT_ ielem, inode1, inode2, inode3, nelem_est;

  double area, dc0, dc1, dc3, dc1d3, df0, dx211, dx212, dx311, dx312, est_i,
         x11, x12, x21, x22, x31, x32;

  dc0 = 0.0;
  dc1 = 1.0;
  dc3 = 3.0;
  dc1d3 = dc1 / dc3;

  est_i = dc0;

  for (ielem = 1; ielem <= nelem; ++ielem)
  {
    inode1 = iniel[ielem][0];
    inode2 = iniel[ielem][1];
    inode3 = iniel[ielem][2];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x21 = x[inode2][0];
    x22 = x[inode2][1];
    x31 = x[inode3][0];
    x32 = x[inode3][1];

    dx211 = x21 - x11;
    dx212 = x22 - x12;
    dx311 = x31 - x11;
    dx312 = x32 - x12;
  
    area = dx211 * dx312 - dx212 * dx311;

    df0 = dc1d3 * (df[inode1] + df[inode2] + df[inode3]);

    est_i = est_i + area / (df0 * df0);
  }

  nelem_est = NINT (est_i);

  if (mmsg == 2)
  {
    snprintf (Text, sizeof(Text), "Maximum Estimate   : Elements          =%10i", (int) nelem_est);
    ug_message (Text);
  }

  return (nelem_est);
}
