#include "UG2_LIB.h"

INT_ ug2_injn
 (INT_ mmsg,
  INT_ mreorder,
  INT_ nnode,
  INT_1D * ielin,
  INT_3D * iniel,
  INT_1D * lielin,
  INT_1D * ipin,
  INT_1D * injn)

{

/*
 * Reorder nodes in connected or un-connected groups using element node
 * connectivity.
 *
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_injn.c,v 1.13 2022/11/21 00:11:08 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  CHAR_133 Text;

  INT_ ielem, ieln, iit, inode, inode1, inode2, inode3, ipass, jnode, jnode0,
       kelem, keln, kloc, kloc1, kloc2, knode, kpass, loc, loc1, loc2, ngroup;

  if (mreorder == 0)
  {
    for (inode = 1; inode <= nnode; ++inode)
    {
      injn[inode] = inode;
    }
  }

  else if (mreorder == 1)
  {
    if (mmsg == 2)
    {
      ug_message (" ");
      ug_message ("UG2      : REORDERING NODES AS CONNECTED GROUPS");
      ug_message (" ");
    }

    for (inode = 1; inode <= nnode; ++inode)
    {
      ipin[inode] = 0;
    }

    knode = 1;

    jnode = 0;

    ipass = 1;

    do
    {
      ++jnode;

      ipin[knode] = ipass;

      injn[jnode] = knode;

      iit = 1;

      do
      {
        jnode0 = jnode;

        loc1 = lielin[knode];
        loc2 = lielin[knode+1] - 1;

        loc = loc1;

        do
        {
          ielem = ielin[loc];

          ieln = 0;

          do
          {
            knode = iniel[ielem][ieln];

            if (ipin[knode] == 0)
            {
              ++jnode;

              ipin[knode] = ipass;

              injn[jnode] = knode;
            }

            ++ieln;
          }
          while (ieln <= 2 && jnode == jnode0);

          ++loc;
        }
        while (loc <= loc2 && jnode == jnode0);

        ++iit;
      }
      while (iit <= nnode && jnode > jnode0);

      if (jnode < nnode)
      {
        knode = 1;

        do
        {
          ++knode;

          kpass = ipin[knode];
        }
        while (knode <= nnode && kpass > 0);

        if (kpass > 0)
        {
          ug_error_message ("*** ERROR 217 : error reordering connected nodes ***");
          return (217);
        }
      }

      ++ipass;
    }
    while (ipass <= nnode && jnode < nnode);

    ngroup = ipass - 1;
  }

  else if (mreorder == 2)
  {
    if (mmsg == 2)
    {
      ug_message (" ");
      ug_message ("UG2      : REORDERING NODES AS UNCONNECTED GROUPS");
      ug_message (" ");
    }

    for (inode = 1; inode <= nnode; ++inode)
    {
      ipin[inode] = 0;
    }

    knode = 1;

    jnode = 0;

    ipass = 1;

    do
    {
      ++jnode;

      ipin[knode] = -ipass;

      injn[jnode] = knode;

      iit = 1;

      do
      {
        jnode0 = jnode;

        inode = knode;

        loc1 = lielin[inode];
        loc2 = lielin[inode+1] - 1;

        for (loc = loc1; loc <= loc2; ++loc)
        {
          ielem = ielin[loc];

          inode1 = iniel[ielem][0];
          inode2 = iniel[ielem][1];
          inode3 = iniel[ielem][2];

          if (ipin[inode1] >= 0) ipin[inode1] = ipass;
          if (ipin[inode2] >= 0) ipin[inode2] = ipass;
          if (ipin[inode3] >= 0) ipin[inode3] = ipass;
        }

        loc = loc1;

        do
        {
          ielem = ielin[loc];

          ieln = 0;

          do
          {
            knode = iniel[ielem][ieln];

            if (knode != inode)
            {
              kloc1 = lielin[knode];
              kloc2 = lielin[knode+1] - 1;

              kloc = kloc1;

              do
              {
                kelem = ielin[kloc];

                keln = 0;

                do
                {
                  knode = iniel[kelem][keln];

                  kpass = ipin[knode];

                  if (kpass >= 0 && kpass != ipass)
                  {
                    ++jnode;

                    ipin[knode] = -ipass;

                    injn[jnode] = knode;
                  }

                  ++keln;
                }
                while (keln <= 2 && jnode == jnode0);

                ++kloc;
              }
              while (kloc <= kloc2 && jnode == jnode0);
            }

            ++ieln;
          }
          while (ieln <= 2 && jnode == jnode0);

          ++loc;
        }
        while (loc <= loc2 && jnode == jnode0);

        ++iit;
      }
      while (iit <= nnode && jnode > jnode0);

      if (jnode < nnode)
      {
        knode = 1;

        do
        {
          ++knode;

          kpass = ipin[knode];
        }
        while (knode <= nnode && kpass < 0);

        if (kpass < 0)
        {
          ug_error_message ("*** ERROR 218 : error reordering connected nodes ***");
          return (218);
        }
      }

      ++ipass;
    }
    while (ipass <= nnode && jnode < nnode);

    ngroup = ipass - 1;
  }

  if (mreorder >= 1)
  {
    jnode = 1;

    do
    {
      inode = injn[jnode];

      ++jnode;
    }
    while (jnode <= nnode && inode > 0);

    if (inode <= 0)
    {
      ug_error_message ("*** ERROR 219 : error reordering connected nodes ***");
      return (219);
    }

    for (inode = 1; inode <= nnode; ++inode)
    {
      ipin[inode] = 0;
    }

    jnode = 1;

    do
    {
      inode = injn[jnode];

      ipass = ipin[inode];

      ipin[inode] = jnode;

      ++jnode;
    }
    while (jnode <= nnode && ipass == 0);

    if (ipass > 0)
    {
      ug_error_message ("*** ERROR 220 : error reordering connected nodes ***");
      return (220);
    }

    inode = 1;

    do
    {
      ipass = ipin[inode];

      ++inode;
    }
    while (inode <= nnode && ipass > 0);

    if (ipass == 0)
    {
      ug_error_message ("*** ERROR 221 : error reordering connected nodes ***");
      return (221);
    }

    if (mmsg == 2)
    {
      snprintf (Text, sizeof(Text), "UG2      : Number of Groups  =%10i", (int) ngroup);
      ug_message (Text);
    }
  }

  return (0);

}
