#include "UG2_LIB.h"

void ug2_inie
 (INT_ nelem,
  INT_ nquad,
  INT_ nnode,
  INT_ *nedge,
  INT_3D * iniel,
  INT_4D * iniq,
  INT_1D * iein1,
  INT_1D * in2ie,
  INT_1D * mchk,
  INT_2D * inie)

{

/*
 * Create edge connectivity.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_inie.c,v 1.12 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ iedge, ielem, inode, inode1, inode2, inode3, inode4, iquad, jedge,
       jedge1, jedge2, jnode1, jnode2, jnode3, jnode4, nepp;

  for (inode = 1; inode <= nnode; ++inode)
  {
    iein1[inode] = 0;
  }

  for (ielem = 1; ielem <= nelem; ++ielem)
  {
    inode1 = iniel[ielem][0];
    inode2 = iniel[ielem][1];
    inode3 = iniel[ielem][2];

    jnode1 = MIN (inode1, inode2);
    jnode2 = MIN (inode2, inode3);
    jnode3 = MIN (inode3, inode1);

    iein1[jnode1] = iein1[jnode1] + 1;
    iein1[jnode2] = iein1[jnode2] + 1;
    iein1[jnode3] = iein1[jnode3] + 1;
  }

  for (iquad = 1; iquad <= nquad; ++iquad)
  {
    inode1 = iniq[iquad][0];
    inode2 = iniq[iquad][1];
    inode3 = iniq[iquad][2];
    inode4 = iniq[iquad][3];

    jnode1 = MIN (inode1, inode2);
    jnode2 = MIN (inode2, inode3);
    jnode3 = MIN (inode3, inode4);
    jnode4 = MIN (inode4, inode1);

    iein1[jnode1] = iein1[jnode1] + 1;
    iein1[jnode2] = iein1[jnode2] + 1;
    iein1[jnode3] = iein1[jnode3] + 1;
    iein1[jnode4] = iein1[jnode4] + 1;
  }

  iedge = 1;

  nepp = 0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    iedge = iedge + nepp;

    nepp = iein1[inode];

    iein1[inode] = iedge;
  }

  for (ielem = 1; ielem <= nelem; ++ielem)
  {
    inode1 = iniel[ielem][0];
    inode2 = iniel[ielem][1];
    inode3 = iniel[ielem][2];

    jnode1 = MIN (inode1, inode2);
    jnode2 = MAX (inode1, inode2);

    iedge = iein1[jnode1];

    in2ie[iedge] = jnode2;

    ++iedge;

    iein1[jnode1] = iedge;

    jnode1 = MIN (inode2, inode3);
    jnode2 = MAX (inode2, inode3);

    iedge = iein1[jnode1];

    in2ie[iedge] = jnode2;

    ++iedge;

    iein1[jnode1] = iedge;

    jnode1 = MIN (inode3, inode1);
    jnode2 = MAX (inode3, inode1);

    iedge = iein1[jnode1];

    in2ie[iedge] = jnode2;

    ++iedge;

    iein1[jnode1] = iedge;
  }

  for (iquad = 1; iquad <= nquad; ++iquad)
  {
    inode1 = iniq[iquad][0];
    inode2 = iniq[iquad][1];
    inode3 = iniq[iquad][2];
    inode4 = iniq[iquad][3];

    jnode1 = MIN (inode1, inode2);
    jnode2 = MAX (inode1, inode2);

    iedge = iein1[jnode1];

    in2ie[iedge] = jnode2;

    ++iedge;

    iein1[jnode1] = iedge;

    jnode1 = MIN (inode2, inode3);
    jnode2 = MAX (inode2, inode3);

    iedge = iein1[jnode1];

    in2ie[iedge] = jnode2;

    ++iedge;

    iein1[jnode1] = iedge;

    jnode1 = MIN (inode3, inode4);
    jnode2 = MAX (inode3, inode4);

    iedge = iein1[jnode1];

    in2ie[iedge] = jnode2;

    ++iedge;

    iein1[jnode1] = iedge;

    jnode1 = MIN (inode4, inode1);
    jnode2 = MAX (inode4, inode1);

    iedge = iein1[jnode1];

    in2ie[iedge] = jnode2;

    ++iedge;

    iein1[jnode1] = iedge;
  }

  for (inode = nnode; inode >= 1; --inode)
  {
     iein1[inode+1] = iein1[inode];
  }

  iein1[1] = 1;

  for (inode = 1; inode <= nnode; ++inode)
  {
     mchk[inode] = 0;
  }

  iedge = 0;

  for (inode1 = 1; inode1 <= nnode; ++inode1)
  {
    jedge1 = iein1[inode1];
    jedge2 = iein1[inode1+1] - 1;

    iein1[inode1] = iedge + 1;

    for (jedge = jedge1; jedge <= jedge2; ++jedge)
    {
      inode2 = in2ie[jedge];

      if (mchk[inode2] != inode1)
      {
        ++iedge;

        inie[iedge][0] = inode1;
        inie[iedge][1] = inode2;

        mchk[inode2] = inode1;
      }
    }
  }

  *nedge = iedge;

  iein1[nnode] = iedge + 1;

  return;

}
