#include "UG2_LIB.h"

void ug2_inibe
 (INT_ nelem,
  INT_ *nbedge,
  INT_3D * ieliel,
  INT_3D * iniel,
  INT_2D * inibe)

{

/*
 * Create boundary edge connectivity map.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_inibe.c,v 1.7 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ ibedge, ielem;

  if (*nbedge == 0)
  {
    ibedge = 0;

    for (ielem = 1; ielem <= nelem; ++ielem)
    {
      if (ieliel[ielem][0] <= 0)
        ++ibedge;

      if (ieliel[ielem][1] <= 0)
        ++ibedge;

      if (ieliel[ielem][2] <= 0)
        ++ibedge;
    }

    *nbedge = ibedge;
  }
  else
  {
    ibedge = 0;

    for (ielem = 1; ielem <= nelem; ++ielem)
    {
      if (ieliel[ielem][0] <= 0)
      {
        ++ibedge;

        ieliel[ielem][0] = -ibedge;

        inibe[ibedge][0] = iniel[ielem][1];
        inibe[ibedge][1] = iniel[ielem][2];
      }

      if (ieliel[ielem][1] <= 0)
      {
        ++ibedge;

        ieliel[ielem][1] = -ibedge;

        inibe[ibedge][0] = iniel[ielem][2];
        inibe[ibedge][1] = iniel[ielem][0];
      }

      if (ieliel[ielem][2] <= 0)
      {
        ++ibedge;

        ieliel[ielem][2] = -ibedge;

        inibe[ibedge][0] = iniel[ielem][0];
        inibe[ibedge][1] = iniel[ielem][1];
      }
    }
  }

  *nbedge = ibedge;

  return;

}
