#include "UG2_LIB.h"

INT_ ug2_ielin
 (INT_ ielem0,
  INT_ nelem,
  INT_ *nelpntd,
  INT_ nnode,
  INT_ *nelpnt,
  INT_3D * iniel,
  INT_1D * madd,
  INT_1D ** ielin_ptr,
  INT_1D * lielin)

{

/*
 * Create a list of elements surrounding a node.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_ielin.c,v 1.18 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_1D * ielin;

  INT_ ielem, ierr, inode, inode1, inode2, inode3, loc, nelpn;

  for (inode = 1; inode <= nnode; ++inode)
  {
    lielin[inode] = 0;
  }

  if (ielem0 > 1)
  {
    for (ielem = ielem0; ielem <= nelem; ++ielem)
    {
      if (madd[ielem] >= 1)
      {
        inode1 = iniel[ielem][0];
        inode2 = iniel[ielem][1];
        inode3 = iniel[ielem][2];

        ++lielin[inode1];
        ++lielin[inode2];
        ++lielin[inode3];
      }
    }
  }
  else
  {
    for (ielem = 1; ielem <= nelem; ++ielem)
    {
      inode1 = iniel[ielem][0];
      inode2 = iniel[ielem][1];
      inode3 = iniel[ielem][2];

      ++lielin[inode1];
      ++lielin[inode2];
      ++lielin[inode3];
    }
  }

  *nelpnt = 0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    *nelpnt = *nelpnt + lielin[inode];
  }

  if (*nelpnt > ug_abs (*nelpntd))
  {
    if (*nelpntd >= 0)
    {
      *nelpntd = *nelpnt;

      ierr = 0;

      *ielin_ptr = (INT_1D *) ug_realloc (&ierr, *ielin_ptr,
                                          (*nelpntd+1) * sizeof (INT_1D));

      if (ierr > 0)
      {
        ug_error_message ("*** ERROR 100201 : unable to allocate required memory ***");
        return (100201);
      }
    }
    else
    {
      ug_error_message ("*** ERROR 100204 : unable to allocate required memory ***");
      return (100204);
    }
  }

  ielin = *ielin_ptr;

  loc = 1;

  nelpn = 0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    loc = loc + nelpn;

    nelpn = lielin[inode];

    lielin[inode] = loc;
  }

  if (ielem0 > 1)
  {
    for (ielem = ielem0; ielem <= nelem; ++ielem)
    {
      if (madd[ielem] >= 1)
      {
        inode1 = iniel[ielem][0];
        inode2 = iniel[ielem][1];
        inode3 = iniel[ielem][2];

        loc = lielin[inode1];

        ielin[loc] = ielem;

        ++loc;

        lielin[inode1] = loc;

        loc = lielin[inode2];

        ielin[loc] = ielem;

        ++loc;

        lielin[inode2] = loc;

        loc = lielin[inode3];

        ielin[loc] = ielem;

        ++loc;

        lielin[inode3] = loc;
      }
    }
  }
  else
  {
    for (ielem = 1; ielem <= nelem; ++ielem)
    {
      inode1 = iniel[ielem][0];
      inode2 = iniel[ielem][1];
      inode3 = iniel[ielem][2];

      loc = lielin[inode1];

      ielin[loc] = ielem;

      ++loc;

      lielin[inode1] = loc;

      loc = lielin[inode2];

      ielin[loc] = ielem;

      ++loc;

      lielin[inode2] = loc;

      loc = lielin[inode3];

      ielin[loc] = ielem;

      ++loc;

      lielin[inode3] = loc;
    }
  }

  for (inode = nnode + 1; inode >= 2; --inode)
  {
    lielin[inode] = lielin[inode-1];
  }

  lielin[1] = 1;

  return (0);

}
