#include "UG2_LIB.h"

INT_ ug2_ieliel2
 (INT_ mmsg,
  INT_ mreorder,
  INT_ nelem,
  INT_1D * ielin,
  INT_3D * iniel,
  INT_1D * lielin,
  INT_1D * ielichk,
  INT_1D * mchkel,
  INT_3D * ieliel)

{

/*
 * Determine element to element connectivity. Simply connected (no more than two
 * elements per edge) grids can are reordered if all elements do not have the
 * same orientation.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_ieliel2.c,v 1.9 2022/11/21 00:11:08 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  CHAR_133 Text;

  INT_ ichk, ielem, ielem1, ielit, ieln, ieln1, ieln2, inode1, inode2, inode3,
       ireorder, jelem, jelem1, jelem2, jeln, jeln1, jeln2, jnode1, jnode2,
       jnode3, kelem, loc, loc1,  loc2, nelit, nchk;

  for (ielem = 1; ielem <= nelem; ++ielem)
  {
    ieliel[ielem][0] = 0;
    ieliel[ielem][1] = 0;
    ieliel[ielem][2] = 0;
  }

  ireorder = 0;

  for (jelem = 1; jelem <= nelem; ++jelem)
  {
    for (jeln = 0; jeln <= 2; ++jeln)
    {
      if (! ieliel[jelem][jeln])
      {
        jeln1 = (jeln < 2) ? jeln+1 : 0;
        jeln2 = (jeln1 < 2) ? jeln1+1 : 0;

        jnode1 = iniel[jelem][jeln1];
        jnode2 = iniel[jelem][jeln2];
        jnode3 = iniel[jelem][jeln];

        ieln = -1;

        loc1 = lielin[jnode1];
        loc2 = lielin[jnode1 + 1] - 1;

        loc = loc1;

        do
        {
          ielem = ielin[loc];

          if (ielem != jelem)
          {
            inode1 = iniel[ielem][0];
            inode2 = iniel[ielem][1];
            inode3 = iniel[ielem][2];

            ieln = (inode1 == jnode2 && inode2 == jnode1) ? 2 :
                   (inode2 == jnode2 && inode3 == jnode1) ? 0 :
                   (inode3 == jnode2 && inode1 == jnode1) ? 1 : -1;

            if (ieln == -1)
            {
              ieln = (inode1 == jnode1 && inode2 == jnode2) ? 2 :
                     (inode2 == jnode1 && inode3 == jnode2) ? 0 :
                     (inode3 == jnode1 && inode1 == jnode2) ? 1 : -1;

              if (ieln >= 0)
              {
                if (mreorder)
                  ireorder = 1;
                else
                {
                  ug_error_message ("*** ERROR 228 : element neighbor connectivity is not consistent ***");
                  return (228); // ordering not consistent
                }
              }
            }

            if (ieln >= 0)
            {
              if (iniel[ielem][ieln] == jnode3)
              {
                ug_error_message ("*** ERROR 229 : duplicate element found ***");
                return (229); // duplicate element
              }

              if (ieliel[ielem][ieln])
              {
                  ug_error_message ("*** ERROR 230 : multiply connected element found ***");
                return (230); // multiply connected
              }

              ieliel[jelem][jeln] = ielem;
              ieliel[ielem][ieln] = jelem;
            }
          }

          ++loc;
        }
        while (loc <= loc2 && ieln < 0);
      }
    }
  }

  if (ireorder)
  {
    if (mmsg == 2)
    {
      snprintf (Text, sizeof(Text), "Re-ordering Elements: Elements         =%10i", (int) nelem);
      ug_message (Text);
    }

    for (ielem = 1; ielem <= nelem; ++ielem)
    {
      mchkel[ielem] = 0;
    }

    ielem = 0;
    jelem = 0;

    do
    {
      ++ielem;

      ieln = 0;

      do
      {
        jelem = ieliel[ielem][ieln];

        if (jelem > 0)
        {
          ieln1 = (ieln < 2) ? ieln+1 : 0;
          ieln2 = (ieln1 < 2) ? ieln1+1 : 0;

          inode1 = iniel[ielem][ieln1];
          inode2 = iniel[ielem][ieln2];

          mchkel[ielem] = 1;
        }

        ++ieln;
      }
      while (ieln <= 2 && ! jelem);

      --ieln;
    }
    while (ielem < nelem && ! jelem);

    if (jelem > 0)
    {
      nelit = nelem;

      ichk = 0;

      ielit = 0;

      do
      {
        kelem = 0;

        jeln = 0;

        do
        {
          if (ieliel[jelem][jeln] == ielem)
          {
            mchkel[jelem] = 1;

            jeln1 = (jeln < 2) ? jeln+1 : 0;
            jeln2 = (jeln1 < 2) ? jeln1+1 : 0;

            jelem1 = ieliel[jelem][jeln1];
            jelem2 = ieliel[jelem][jeln2];

            jnode1 = iniel[jelem][jeln1];
            jnode2 = iniel[jelem][jeln2];

            if (inode1 == jnode1)
            {
              ieliel[jelem][jeln1] = jelem2;
              ieliel[jelem][jeln2] = jelem1;

              iniel[jelem][jeln1] = jnode2;
              iniel[jelem][jeln2] = jnode1;

              ielem1 = jelem1;
              jelem1 = jelem2;
              jelem2 = ielem1;

              inode1 = jnode1;
              jnode1 = jnode2;
              jnode2 = inode1;
            }

            if (jelem1 > 0)
            {
              if (! mchkel[jelem1])
              {
                inode1 = jnode2;
                inode2 = iniel[jelem][jeln];

                ieln = jeln;

                kelem = jelem;
                jelem = jelem1;
              }
            }

            if (jelem2 > 0)
            {
              if (! mchkel[jelem2])
              {
                if (! kelem)
                {
                  inode1 = iniel[jelem][jeln];
                  inode2 = jnode1;

                  ieln = jeln;

                  kelem = jelem;
                  jelem = jelem2;
                }
                else
                {
                  ++ichk;

                  ielichk[ichk] = jelem;
                }
              }
            }

            if (! kelem)
              kelem = -1;
          }

          ++jeln;
        }
        while (jeln <= 2 && ! kelem);

        if (kelem > 0)
          ielem = kelem;

        else if (kelem == -1)
        {
          ielem = 0;
          kelem = 0;

          nchk = ichk;

          if (nchk > 0)
          {
            ichk = 0;

            do
            {
              ++ichk;

              ielem = ielichk[ichk];

              if (mchkel[ielem])
              {
                ieln = 0;

                do
                {
                  jelem = ieliel[ielem][ieln];

                  if (jelem > 0)
                  {
                    if (! mchkel[jelem])
                    {
                      kelem = ielem;

                      ieln1 = (ieln < 2) ? ieln+1 : 0;
                      ieln2 = (ieln1 < 2) ? ieln1+1 : 0;

                      inode1 = iniel[ielem][ieln1];
                      inode2 = iniel[ielem][ieln2];
                    }
                  }

                  ++ieln;
                }
                while (ieln <= 2 && ! kelem);

                --ieln;
              }
            }
            while (ichk < nchk && ! kelem);
          }

          ichk = 0;

          if (! kelem)
          {
            ielem = 0;

            do
            {
              ++ielem;

              if (mchkel[ielem])
              {
                ieln = 0;

                do
                {
                  jelem = ieliel[ielem][ieln];

                  if (jelem > 0)
                  {
                    if (! mchkel[jelem])
                    {
                      kelem = ielem;

                      ieln1 = (ieln < 2) ? ieln+1 : 0;
                      ieln2 = (ieln1 < 2) ? ieln1+1 : 0;

                      inode1 = iniel[ielem][ieln1];
                      inode2 = iniel[ielem][ieln2];
                    }
                  }

                  ++ieln;
                }
                while (ieln <= 2 && ! kelem);

                --ieln;
              }
            }
            while (ielem < nelem && ! kelem);
          }

          if (! kelem)
          {
            ielem = 0;
            jelem = 0;

            do
            {
              ++ielem;

              if (! mchkel[ielem])
              {
                ieln = 0;

                do
                {
                  jelem = ieliel[ielem][ieln];

                  if (jelem > 0)
                  {
                    kelem = ielem;

                    ieln1 = (ieln < 2) ? ieln+1 : 0;
                    ieln2 = (ieln1 < 2) ? ieln1+1 : 0;

                    inode1 = iniel[ielem][ieln1];
                    inode2 = iniel[ielem][ieln2];

                    mchkel[ielem] = 1;
                  }

                  ++ieln;
                }
                while (ieln <= 2 && ! jelem);

                --ieln;
              }
            }
            while (ielem < nelem && ! jelem);
          }

          ielem = kelem;
        }

        else
        {
          ug_error_message ("*** ERROR 231 : unable to reroder elements ***");
          return (231); // unable to reorder
        }


        ++ielit;
      }
      while (ielit <= nelit && ielem > 0);
    }
  }

  return (0);

}
