#include "UG2_LIB.h"

INT_ ug2_ieliel
 (INT_ nelem,
  INT_1D * ielin,
  INT_3D * iniel,
  INT_1D * lielin,
  INT_3D * ieliel)

{

/*
 * Determine the element to element connectivity.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_ieliel.c,v 1.13 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ ielem, ielf, ieln, ieln1, ieln2, inode, jelem, jelf, jeln, jnode, jnode1,
       jnode2, loc, loc1, loc2, mfound, mset;

  INT_ ienielf[3][2] =
  {
    {1, 2},
    {2, 0},
    {0, 1}};

  INT_ melf[3];

  for (ielem = 1; ielem <= nelem; ++ielem)
  {
    ieliel[ielem][0] = 0;
    ieliel[ielem][1] = 0;
    ieliel[ielem][2] = 0;
  }

  for (jelem = 1; jelem <= nelem; ++jelem)
  {
    for (jelf = 0; jelf <= 2; ++jelf)
    {
      if (ieliel[jelem][jelf] == 0)
      {
        mfound = 0;

        melf[0] = 0;
        melf[1] = 0;
        melf[2] = 0;

        ieln1 = ienielf[jelf][0];
        ieln2 = ienielf[jelf][1];

        jnode1 = iniel[jelem][ieln1];
        jnode2 = iniel[jelem][ieln2];

        loc1 = lielin[jnode1];
        loc2 = lielin[jnode1 + 1] - 1;

        loc = loc1;

        do
        {
          ielem = ielin[loc];

          if (ielem != jelem)
          {
            ieln = 0;

            do
            {
              inode = iniel[ielem][ieln];

              if (inode == jnode1)
              {
                jeln = 0;

                do
                {
                  jnode = iniel[ielem][jeln];

                  if (jnode == jnode2)
                  {
                    melf[ieln] = 1;
                    melf[jeln] = 1;

                    mfound = 1;
                  }

                  ++jeln;
                }
                while (jeln <= 2 && mfound == 0);
              }

              ++ieln;
            }
            while (ieln <= 2 && mfound == 0);
          }

          ++loc;
        }
        while (loc <= loc2 && mfound == 0);

        if (mfound == 1)
        {
          mset = 0;

          ielf = 0;

          do
          {
            if (melf[ielf] == 0)
            {
              ieliel[jelem][jelf] = ielem;
              ieliel[ielem][ielf] = jelem;

              mset = 1;
            }

            ++ielf;
          }
          while (ielf <= 2 && mset == 0);

          if (mset == 0)
          {
            ug_error_message ("*** ERROR 214 : element neighbor connectivity is not valid ***");
            return (214);
          }
        }
      }
    }
  }

  return (0);

}
