#include "UG2_LIB.h"

INT_ ug2_ielibe2
 (INT_ nbedge,
  INT_ nelem,
  INT_3D * ieliel,
  INT_1D * ielibe)

{

/*
 * Determine for each boundary edge the element that contains the edge from the
 * element to element connectivity.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_ielibe2.c,v 1.14 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ ibedge, ielem, ielem1, ielem2, ielem3;

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    ielibe[ibedge] = 0;
  }

  for (ielem = 1; ielem <= nelem; ++ielem)
  {
    ielem1 = ieliel[ielem][0];
    ielem2 = ieliel[ielem][1];
    ielem3 = ieliel[ielem][2];

    if (ielem1 < 0)
    {
      ibedge = -ielem1;

      ielibe[ibedge] = ielem;
    }

    if (ielem2 < 0)
    {
      ibedge = -ielem2;

      ielibe[ibedge] = ielem;
    }

    if (ielem3 < 0)
    {
      ibedge = -ielem3;

      ielibe[ibedge] = ielem;
    }
  }

  ibedge = 1;

  do
  {
    ielem = ielibe[ibedge];

    ++ibedge;
  }
  while (ibedge <= nbedge && ielem > 0);

  if (ielem == 0)
  {
    ug_error_message ("*** ERROR 213 : error in boundary element to boundary edge connectivity ***");
    return (213);
  }

  return (0);

}
