#include "UG2_LIB.h"

void ug2_ielibe0
 (INT_ mbedir,
  INT_ nbedge,
  INT_ nelem,
  INT_ nnode,
  INT_2D * inibe,
  INT_3D * iniel,
  INT_1D * ibejbe,
  INT_1D * ibejn,
  INT_1D * ielibe)

{

/*
 * Determine for each boundary edge the element that contains the edge.
 * Determine either the element inside the domain if mbedir=1 or outside if
 * mbedir=-1.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_ielibe0.c,v 1.9 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ ibedge, ibedge1, ibedge2, ibedge3, ibeg, iben1, iben2, ielem, inode,
       inode1, inode2, inode3, jbedge, jbedge1, jbedge2, jnode1, jnode2;

  if (mbedir == 1)
  {
    iben1 = 0;
    iben2 = 1;
  }
  else
  {
    iben1 = 1;
    iben2 = 0;
  }

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    ielibe[ibedge] = 0;
  }

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    ibejbe[ibedge] = ibedge;
  }

  jbedge2 = 0;

  ibeg = 1;

  do
  {
    for (inode = 1; inode <= nnode; ++inode)
    {
      ibejn[inode] = 1;
    }

    jbedge1 = jbedge2 + 1;

    for (jbedge = jbedge1; jbedge <= nbedge; ++jbedge)
    {
      ibedge = ibejbe[jbedge];

      inode1 = inibe[ibedge][iben1];

      if (ibejn[inode1] == 1)
      {
        inode2 = inibe[ibedge][iben2];

        if (ibejn[inode2] == 1)
        {
          ++jbedge2;

          ibedge2 = ibejbe[jbedge2];

          ibejbe[jbedge2] = ibedge;

          ibejbe[jbedge] = ibedge2;

          ibejn[inode1] = 0;
          ibejn[inode2] = 0;
        }
      }
    }

    for (inode = 1; inode <= nnode; ++inode)
    {
      ibejn[inode] = nbedge + inode;
    }

    for (jbedge = jbedge1; jbedge <= jbedge2; ++jbedge)
    {
      ibedge = ibejbe[jbedge];

      inode1 = inibe[ibedge][iben1];
      inode2 = inibe[ibedge][iben2];

      ibejn[inode1] = ibedge;
      ibejn[inode2] = ibedge;
    }

    for (ielem = 1; ielem <= nelem; ++ielem)
    {
      inode1 = iniel[ielem][0];
      inode2 = iniel[ielem][1];
      inode3 = iniel[ielem][2];

      ibedge1 = ibejn[inode1];
      ibedge2 = ibejn[inode2];
      ibedge3 = ibejn[inode3];

      if (ibedge2 == ibedge3)
      {
        ibedge = ibedge2;

        jnode1 = inibe[ibedge][iben1];
        jnode2 = inibe[ibedge][iben2];

        if (jnode1 == inode2 && jnode2 == inode3)
           ielibe[ibedge] = ielem;
      }

      if (ibedge3 == ibedge1)
      {
        ibedge = ibedge3;

        jnode1 = inibe[ibedge][iben1];
        jnode2 = inibe[ibedge][iben2];

        if (jnode1 == inode3 && jnode2 == inode1)
           ielibe[ibedge] = ielem;
      }

      if (ibedge1 == ibedge2)
      {
        ibedge = ibedge1;

        jnode1 = inibe[ibedge][iben1];
        jnode2 = inibe[ibedge][iben2];

        if (jnode1 == inode1 && jnode2 == inode2)
           ielibe[ibedge] = ielem;
      }
    }

    ++ibeg;
  }
  while (ibeg <= nbedge && jbedge2 < nbedge);

  return;

}
