#include "UG2_LIB.h"

INT_ ug2_ielibe
 (INT_ minl,
  INT_ mmsg,
  INT_ nbedge,
  INT_ nelem,
  INT_ nnode,
  INT_ *nbedgeu,
  INT_3D * ieliel,
  INT_2D * inibe,
  INT_3D * iniel,
  INT_1D * ibejbe,
  INT_1D * ibejn,
  INT_1D * jelibe,
  INT_1D * ielibe,
  INT_1D * ierribe)

{

/*
 * Determine for each boundary edge the element that contains that edge and set
 * the element neighbors at boundaries.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_ielibe.c,v 1.18 2022/11/21 00:11:08 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  CHAR_133 Text;

  INT_ ibedge, ielem, ieln, ierr, inode1, inode2, jelem, jnode1, jnode2, mbedir;

  mbedir = 1;

  ug2_ielibe0 (mbedir, nbedge, nelem, nnode,
               inibe, iniel, ibejbe, ibejn, ielibe);

  if (minl == 1)
  {
    mbedir = -1;

    ug2_ielibe0 (mbedir, nbedge, nelem, nnode,
                 inibe, iniel, ibejbe, ibejn, jelibe);
  }

  *nbedgeu = 0;

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    if (ielibe[ibedge] == 0)
      ++(*nbedgeu);
  }

  if (*nbedgeu == 0)
  {
    if (mmsg == 2)
    {
      snprintf (Text, sizeof(Text), "Boundary Recovery  : Unrecovered Edges =%10i", (int) *nbedgeu);
      ug_message (Text);
    }

    if (minl == -1)
    {
      mbedir = -1;
  
      ug2_ielibe0 (mbedir, nbedge, nelem, nnode,
                   inibe, iniel, ibejbe, ibejn, jelibe);
    }

    for (ibedge = 1; ibedge <= nbedge; ++ibedge)
    {
      ielem = ielibe[ibedge];

      jnode1 = iniel[ielem][0];
      jnode2 = iniel[ielem][1];

      inode1 = inibe[ibedge][0];
      inode2 = inibe[ibedge][1];

      ieln = (jnode1 != inode1 && jnode1 != inode2) ? 0 :
             (jnode2 != inode1 && jnode2 != inode2) ? 1 : 2;

      if(minl == -1)
        ieliel[ielem][ieln] = -jelibe[ibedge];
      else
        ieliel[ielem][ieln] = -ibedge;
    }

    if (minl == -1 || minl == 1)
    {
      ierr = 0;

      for (ibedge = 1; ibedge <= nbedge; ++ibedge)
      {
        jelem = jelibe[ibedge];

        if (jelem == 0)
        {
          ierr = 1;

          ierribe[ibedge] = -1;
        }

        jnode1 = iniel[jelem][0];
        jnode2 = iniel[jelem][1];

        inode1 = inibe[ibedge][0];
        inode2 = inibe[ibedge][1];

        ieln = (jnode1 != inode1 && jnode1 != inode2) ? 0 :
               (jnode2 != inode1 && jnode2 != inode2) ? 1 : 2;

        if(minl == -1)
          ieliel[jelem][ieln] = -ielibe[ibedge];
        else
          ieliel[jelem][ieln] = 0;
      }

      if (ierr == 1)
        return (200207);
    }
  }
  else
  {
    if (minl == -1)
      return (0);   

    if (minl == 2)
    {

      for (ielem = 1; ielem <= nelem; ++ielem)
      {
        if (ieliel[ielem][0] < 0)
          ieliel[ielem][0] = 0;
        if (ieliel[ielem][1] < 0)
          ieliel[ielem][1] = 0;
        if (ieliel[ielem][2] < 0)
          ieliel[ielem][2] = 0;
      }
    }

    if (minl == 0)
    {

      for (ibedge = 1; ibedge <= nbedge; ++ibedge)
      {
        if (ielibe[ibedge] == 0)
          ierribe[ibedge] = -1;
      }

      return (200208);
    }
    else
    {
      if (mmsg == 2)
      {
        snprintf (Text, sizeof(Text), "Boundary Recovery  : Unrecovered Edges =%10i", (int) *nbedgeu);
        ug_message (Text);
      }

      for (ibedge = 1; ibedge <= nbedge; ++ibedge)
      {
        ielem = ielibe[ibedge];

        if (ielem > 0)
        {
          jnode1 = iniel[ielem][0];
          jnode2 = iniel[ielem][1];

          inode1 = inibe[ibedge][0];
          inode2 = inibe[ibedge][1];

          ieln = (jnode1 != inode1 && jnode1 != inode2) ? 0 :
                 (jnode2 != inode1 && jnode2 != inode2) ? 1 : 2;

          ieliel[ielem][ieln] = -ibedge;
        }
      }
    }

    if (minl == 1)
    {
      ierr = 0;

      for (ibedge = 1; ibedge <= nbedge; ++ibedge)
      {
        ielem = ielibe[ibedge];

        if (ielem > 0)
        {
          jelem = jelibe[ibedge];

          if (jelem == 0)
          {
            ierr = 1;

            ierribe[ibedge] = -1;
          }

          jnode1 = iniel[jelem][0];
          jnode2 = iniel[jelem][1];

          inode1 = inibe[ibedge][0];
          inode2 = inibe[ibedge][1];

          ieln = (jnode1 != inode1 && jnode1 != inode2) ? 0 :
                 (jnode2 != inode1 && jnode2 != inode2) ? 1 : 2;

          ieliel[jelem][ieln] = 0;
        }
      }

      if (ierr == 1)
        return (200209);
    }
  }

  return (0);

}
