#include "UG2_LIB.h"

INT_ ug2_iein
 (INT_ iedge0,
  INT_ nedge,
  INT_ *nepntd,
  INT_ nnode,
  INT_ *nepnt,
  INT_2D * inie,
  INT_1D * madd,
  INT_1D ** iein_ptr,
  INT_1D * liein)

{

/*
 * Create a list of edges surrounding a node.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_iein.c,v 1.9 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_1D * iein;

  INT_ iedge, ierr, inode, inode1, inode2, loc, nepn;

  for (inode = 1; inode <= nnode; ++inode)
  {
    liein[inode] = 0;
  }

  if (iedge0 > 1)
  {
    for (iedge = iedge0; iedge <= nedge; ++iedge)
    {
      if (madd[iedge] >= 1)
      {
        inode1 = inie[iedge][0];
        inode2 = inie[iedge][1];

        ++liein[inode1];
        ++liein[inode2];
      }
    }
  }
  else
  {
    for (iedge = 1; iedge <= nedge; ++iedge)
    {
      inode1 = inie[iedge][0];
      inode2 = inie[iedge][1];

      ++liein[inode1];
      ++liein[inode2];
    }
  }

  *nepnt = 0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    *nepnt = *nepnt + liein[inode];
  }

  if (*nepnt > *nepntd)
  {
    *nepntd = *nepnt;

    ierr = 0;

    *iein_ptr = (INT_1D *) ug_realloc (&ierr, *iein_ptr,
                                       (*nepntd+1) * sizeof (INT_1D));

    if (ierr > 0)
    {
      ug_error_message ("*** ERROR 100202 : unable to allocate required memory ***");
      return (100202);
    }
  }

  iein = *iein_ptr;

  loc = 1;

  nepn = 0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    loc = loc + nepn;

    nepn = liein[inode];

    liein[inode] = loc;
  }

  if (iedge0 > 1)
  {
    for (iedge = iedge0; iedge <= nedge; ++iedge)
    {
      if (madd[iedge] >= 1)
      {
        inode1 = inie[iedge][0];
        inode2 = inie[iedge][1];

        loc = liein[inode1];

        iein[loc] = iedge;

        ++loc;

        liein[inode1] = loc;

        loc = liein[inode2];

        iein[loc] = iedge;

        ++loc;

        liein[inode2] = loc;
      }
    }
  }
  else
  {
    for (iedge = 1; iedge <= nedge; ++iedge)
    {
      inode1 = inie[iedge][0];
      inode2 = inie[iedge][1];

      loc = liein[inode1];

      iein[loc] = iedge;

      ++loc;

      liein[inode1] = loc;

      loc = liein[inode2];

      iein[loc] = iedge;

      ++loc;

      liein[inode2] = loc;
    }
  }

  for (inode = nnode + 1; inode >= 2; --inode)
  {
    liein[inode] = liein[inode-1];
  }

  liein[1] = 1;

  return (0);

}
