#include "UG2_LIB.h"

void ug2_ibor
 (INT_ mmsg,
  INT_ nbedge,
  INT_ nbo,
  INT_ nnode,
  INT_2D * ibeibe,
  INT_1D * ibein,
  INT_1D * iboibe,
  INT_2D * inibe,
  INT_1D * libein,
  DOUBLE_2D * x)

{

/*
 * Re-order the boundary edge grid connectivity if any boundary object does not
 * have RH orientation and reorder boundary object map so that the external
 * boundary object is first in the list. 
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_ibor.c,v 1.19 2022/11/21 00:11:08 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 * character*60 txt
 */

  CHAR_133 Text;

  INT_ ibedge, ibedge1, ibedge2, ibo, iboext, inode, inode1, inode2,
       jbo, jnode, loc, loc1, loc2;
  INT_ idir = 1;

  double a1, a2, dc0, dx211, dx212, w, wm, wmax, x1, x1max, x1maxm, x1min,
         x1mini, x1minm, x11, x12, x2, x2max, x2maxm, x2min, x2minm, x21, x22;

  dc0 = 0.0;

  inode = 1;

  x1 = x[inode][0];
  x2 = x[inode][1];

  x1maxm = x1;
  x1minm = x1;
  x2maxm = x2;
  x2minm = x2;

  for (inode = 2; inode <= nnode; ++inode)
  {
    x1 = x[inode][0];
    x2 = x[inode][1];

    x1maxm = MAX (x1maxm, x1);
    x1minm = MIN (x1minm, x1);
    x2maxm = MAX (x2maxm, x2);
    x2minm = MIN (x2minm, x2);
  }

  ibo = 1;

  do
  {
    x1max = x1minm;
    x1min = x1maxm;
    x2max = x2minm;
    x2min = x2maxm;

    for (ibedge = 1; ibedge <= nbedge; ++ibedge)
    {
      if (iboibe[ibedge] == ibo)
      {
        inode = inibe[ibedge][0];

        x1 = x[inode][0];
        x2 = x[inode][1];

        x1max = MAX (x1max, x1);
        x1min = MIN (x1min, x1);
        x2max = MAX (x2max, x2);
        x2min = MIN (x2min, x2);
      }
    }

    iboext = (x1min == x1minm && x1max == x1maxm && 
              x2min == x2minm && x2max == x2maxm) ? ibo : 0;

    ++ibo;
  }
  while (ibo <= nbo && iboext == 0);

  // reorder boundary objects

  if (iboext > 1 && nbo > 1)
  {
    for (ibo = nbo; ibo >= 1; --ibo)
    {
      if (ibo <= iboext)
      {
        jbo = (ibo == iboext) ? -1: ibo+1;

        for (ibedge = 1; ibedge <= nbedge; ++ibedge)
        {
          if (iboibe[ibedge] == ibo)
            iboibe[ibedge] = jbo;
        }
      }
    }

    for (ibedge = 1; ibedge <= nbedge; ++ibedge)
    {
      if (iboibe[ibedge] == -1)
        iboibe[ibedge] = 1;
    }
  }

  for (ibo = 1; ibo <= nbo; ++ibo)
  {
    x1max = x1minm;
    x1min = x1maxm;

    for (ibedge = 1; ibedge <= nbedge; ++ibedge)
    {
      if (iboibe[ibedge] == ibo)
      {
        inode = inibe[ibedge][0];

        x1 = x[inode][0];

        x1max = MAX (x1max, x1);
        x1min = MIN (x1min, x1);
      }
    }

    jnode = 0;

    x1mini = x1max;

    for (ibedge = 1; ibedge <= nbedge; ++ibedge)
    {
      if (iboibe[ibedge] == ibo)
      {
        inode1 = inibe[ibedge][0];
        inode2 = inibe[ibedge][1];

        x11 = x[inode1][0];
        x21 = x[inode2][0];

        if (x11 <= x1mini)
        {
          jnode = inode1;

          x1mini = x11;
        }

        if (x21 <= x1mini)
        {
          jnode = inode2;

          x1mini = x21;
        }
      }
    }

    wmax = dc0;

    loc1 = libein[jnode];
    loc2 = libein[jnode+1] - 1;

    for (loc = loc1; loc <= loc2; ++loc)
    {
      ibedge = ibein[loc];

      inode1 = inibe[ibedge][0];
      inode2 = inibe[ibedge][1];

      x11 = x[inode1][0];
      x12 = x[inode1][1];
      x21 = x[inode2][0];
      x22 = x[inode2][1];

      dx211 = x21 - x11;
      dx212 = x22 - x12;

      a1 = - dx212;
      a2 =   dx211;

      w = a1 / sqrt (a1 * a1 + a2 * a2);

      wm = fabs (w);

      if (wm > wmax)
      {
        wmax = wm;

        idir = (w < dc0) ? -1 : 1;
      }
    }

    if (iboext && iboext != ibo)
      idir = -idir;

    if (idir == -1)
    {
      if (mmsg == 2)
      {
        snprintf (Text, sizeof(Text), "Boundary Objects   : Re-Ordered Object =%10i", (int) ibo);
        ug_message (Text);
      }

      for (ibedge = 1; ibedge <= nbedge; ++ibedge)
      {
        if (iboibe[ibedge] == ibo)
        {
          ibedge1 = ibeibe[ibedge][0];
          ibedge2 = ibeibe[ibedge][1];

          inode1 = inibe[ibedge][0];
          inode2 = inibe[ibedge][1];

          ibeibe[ibedge][0] = ibedge2;
          ibeibe[ibedge][1] = ibedge1;

          inibe[ibedge][0] = inode2;
          inibe[ibedge][1] = inode1;
        }
      }
    }
  }

  if (mmsg == 2)
  {
    snprintf (Text, sizeof(Text), "Boundary Objects   : External Object   =%10i", (int) iboext);
    ug_message (Text);
  }

  return;

}
