#include "UG2_LIB.h"

void ug2_iboibe
 (INT_ mmsg,
  INT_ nbedge,
  INT_ *nbo,
  INT_2D * ibeibe,
  INT_1D * iboibe)

{

/*
 * Determine the number of closed or open boundary objects (curves).
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_iboibe.c,v 1.14 2022/11/21 00:11:08 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  CHAR_133 Text;

  INT_ ibedge, ibedge0, ibo, mfound;

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    iboibe[ibedge] = 0;
  }

  ibedge = 1;

  ibo = 0;

  do
  {
    ++ibo;

    ibedge0 = ibedge;

    do
    {
      // set boundary edge object index

      iboibe[ibedge] = ibo;

      // set next boundary edge

      ibedge = ibeibe[ibedge][0];
    }
    while (ibedge != ibedge0 && ibedge != 0);

    // if the object is a free object then search backwards for opposite end

    if (ibedge == 0)
    {
      ibedge = ibedge0;

      do
      {
        // set boundary edge object index

        iboibe[ibedge] = ibo;

        // set next boundary edge

        ibedge = ibeibe[ibedge][1];
      }
      while (ibedge != ibedge0 && ibedge != 0);
    }

    // find a boundary edge with an unset object index

    mfound = 0;

    ibedge = 0;

    do
    {
      ++ibedge;

      if (iboibe[ibedge] == 0)
        mfound = 1;
    }
    while (ibedge < nbedge && mfound == 0);
  }
  while (mfound == 1);

  *nbo = ibo;

  if (mmsg == 2)
  {
    snprintf (Text, sizeof(Text), "Boundary Objects   : Objects           =%10i", (int) *nbo);
    ug_message (Text);
  }

  return;

}
