#include "UG2_LIB.h"

INT_ ug2_ibein
 (INT_ nbedge,
  INT_ *nbepntd,
  INT_ nnode,
  INT_ *nbepnt,
  INT_2D * inibe,
  INT_1D ** ibein_ptr,
  INT_1D * libein)

{

/*
 * Create a list of boundary edges surrounding a node.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_ibein.c,v 1.10 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_1D * ibein;

  INT_ ibedge, ierr, inode, inode1, inode2, loc, nbepn;

  for (inode = 1; inode <= nnode; ++inode)
  {
    libein[inode] = 0;
  }

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    inode1 = inibe[ibedge][0];
    inode2 = inibe[ibedge][1];

    ++libein[inode1];
    ++libein[inode2];
  }

  *nbepnt = 0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    *nbepnt = *nbepnt + libein[inode];
  }

  if (*nbepnt > *nbepntd)
  {
    *nbepntd = *nbepnt;

    ierr = 0;

    *ibein_ptr = (INT_1D *) ug_realloc (&ierr, *ibein_ptr,
                                        (*nbepntd+1) * sizeof (INT_1D));

    if (ierr > 0)
    {
      ug_error_message ("*** ERROR 100203 : unable to allocate required memory ***");
      return (100203);
    }
  }

  ibein = *ibein_ptr;

  loc = 1;

  nbepn = 0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    loc = loc + nbepn;

    nbepn = libein[inode];

    libein[inode] = loc;
  }

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    inode1 = inibe[ibedge][0];
    inode2 = inibe[ibedge][1];

    loc = libein[inode1];

    ibein[loc] = ibedge;

    ++loc;

    libein[inode1] = loc;

    loc = libein[inode2];

    ibein[loc] = ibedge;

    ++loc;

    libein[inode2] = loc;
  }

  for (inode = nnode + 1; inode >= 2; --inode)
  {
    libein[inode] = libein[inode-1];
  }

  libein[1] = 1;

  return (0);

}
