#include "UG2_LIB.h"

INT_ ug2_ibeibe
 (INT_ merr,
  INT_ mmsg,
  INT_ mmultc,
  INT_ mreorder,
  INT_ nbedge,
  INT_ nx,
  INT_1D * ibein,
  INT_2D * inibe,
  INT_1D * libein,
  INT_1D * mchkbe,
  INT_2D * ibeibe,
  INT_1D * ierribe,
  DOUBLE_1D * x)

{

/*
 * Determine boundary edge to boundary edge connectivity. Simply connected edges
 * (no more than two boundary edges per boundary node) are reordered if all
 * edges do not have the save orientation.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_ibeibe.c,v 1.27 2022/11/21 00:11:08 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  CHAR_133 Text;

  DOUBLE_2D *x2d = NULL;

  INT_ ibedge, ibedge1, ibedge2, ibeit, iben, ibepn, iboit, ierr, inode1,
       inode2, irbedge, ireorder, jbedge, jbepn, jnode1, jnode2, kbedge, loc,
       loc1, loc2, mben, mchkbei, mfound, mfree, nbepn;

  double dc0, dc2, dc4, dx21i1, dx21i2, dx21im,  dx21j1, dx21j2, dx21jm, w1,
         w1max, w2, x11, x12, x21, x22, x31, x32;
 
  dc0 = 0.0;
  dc2 = 2.0;
  dc4 = 4.0;

  ierr = 0;

  if (nx == 2)
    x2d = (DOUBLE_2D *) x;

  for (jbedge = 1; jbedge <= nbedge; ++jbedge)
  {
    jnode1 = inibe[jbedge][0];
    jnode2 = inibe[jbedge][1];

    loc1 = libein[jnode1];
    loc2 = libein[jnode1+1] - 1;

    for (loc = loc1; loc <= loc2; ++loc)
    {
      ibedge = ibein[loc];

      if (ibedge != jbedge)
      {
        inode1 = inibe[ibedge][0];
        inode2 = inibe[ibedge][1];

        if (inode1 == jnode2 || inode2 == jnode2)
        {
          ierr = 1;

          if (merr == 1)
          {
            ierribe[ibedge] = -1;
            ierribe[jbedge] = -1;
          }
          else
          {
            ug_error_message ("*** ERROR 241 : duplicate boundary edges found ***");
            return (241);
          }
        }
      }
    }
  }

  if (ierr == 1)
  {
    ug_error_message ("*** ERROR 200212 : duplicate boundary edges found ***");
    return (200212);
  }

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    mchkbe[ibedge] = 0;

    ibeibe[ibedge][0] = 0;
    ibeibe[ibedge][1] = 0;
  }

  kbedge = 0;

  for (jbedge = 1; jbedge <= nbedge; ++jbedge)
  {
    ibepn = 0;

    jnode2 = inibe[jbedge][1];

    loc1 = libein[jnode2];
    loc2 = libein[jnode2+1] - 1;

    if (loc2 == loc1+1)
    {
      for (loc = loc1; loc <= loc2; ++loc)
      {
        ibedge = ibein[loc];

        if (ibedge != jbedge && inibe[ibedge][0] == jnode2)
        {
          ++kbedge;

          ibeibe[jbedge][0] = ibedge;
          ibeibe[ibedge][1] = jbedge;
        }
      }
    }
  }

  if (kbedge < nbedge)
  {
    mfree = 0;

    for (jbedge = 1; jbedge <= nbedge; ++jbedge)
    {
      jnode1 = inibe[jbedge][0];
      jnode2 = inibe[jbedge][1];

      loc1 = libein[jnode1];
      loc2 = libein[jnode1+1] - 1;

      if (loc2 == loc1)
      {
        mfree = 1;

        ibedge = ibein[loc1];

        mchkbe[ibedge] = 1;
      }

      loc1 = libein[jnode2];
      loc2 = libein[jnode2+1] - 1;

      if (loc2 == loc1)
      {
        mfree = 1;

        ibedge = ibein[loc1];

        mchkbe[ibedge] = 1;
      }
    }

    if (mfree)
    {
      kbedge = 0;

      do
      {
        mfound = 0;

        ibedge = kbedge;

        do
        {
          ++ibedge;

          if (mchkbe[ibedge] == 1)
            mfound = 1;
        }
        while (ibedge < nbedge && mfound == 0);

        if (mfound)
        {
          mchkbe[ibedge] = -1;

          jbedge = ibedge;

          do
          {
            jbedge = ibeibe[jbedge][0];

            if (jbedge) mchkbe[jbedge] = -1;
          }
          while (jbedge);

          jbedge = ibedge;

          do
          {
            jbedge = ibeibe[jbedge][1];

            if (jbedge) mchkbe[jbedge] = -1;
          }
          while (jbedge);

          kbedge = ibedge;
        }
      }
      while (mfound && kbedge < nbedge);
    }

    ierr = 0;

    ireorder = 0;

    mben = 0;

    for (jbedge = 1; jbedge <= nbedge; ++jbedge)
    {
      ibepn = 0;
      jbepn = 1;

      jnode2 = inibe[jbedge][1];

      loc1 = libein[jnode2];
      loc2 = libein[jnode2+1] - 1;

      for (loc = loc1; loc <= loc2; ++loc)
      {
        ibedge = ibein[loc];

        if (ibedge != jbedge && mchkbe[ibedge] == mchkbe[jbedge])
        {
          if (inibe[ibedge][0] == jnode2)
          {
            kbedge = ibedge;

            ++ibepn;
          }

          if (inibe[ibedge][1] == jnode2)
          {
            ++jbepn;
          }
        }
      }

      nbepn = ibepn + jbepn;

      if (nbepn > 2)
      {
        if (mmultc == 0)
          ierr = 2;
        else if (mmultc == 1 && nx == 2)
        {
          if (nbepn % 2 != 0)
            ierr = 1;
          else if (ibepn != jbepn)
            ierr = 3;
          else if (ireorder == 1)
            ierr = 4;
          else
          {
            mben = 1;

            jnode1 = inibe[jbedge][0];

            x11 = x2d[jnode1][0];
            x12 = x2d[jnode1][1];
            x21 = x2d[jnode2][0];
            x22 = x2d[jnode2][1];

            dx21j1 = x21 - x11;
            dx21j2 = x22 - x12;

            dx21jm = sqrt (dx21j1 * dx21j1 + dx21j2 * dx21j2);

            w1max = -dc4;
         
            for (loc = loc1; loc <= loc2; ++loc)
            {
              ibedge = ibein[loc];
         
              if (ibedge != jbedge)
              {
                inode2 = inibe[ibedge][1];

                if (inode2 != jnode2)
                {
                  x31 = x2d[inode2][0];
                  x32 = x2d[inode2][1];

                  dx21i1 = x21 - x31;
                  dx21i2 = x22 - x32;

                  dx21im = sqrt (dx21i1 * dx21i1 + dx21i2 * dx21i2);

                  w1 = (dx21j1 * dx21i1 + dx21j2 * dx21i2)
                     / (dx21jm * dx21im);
                  w2 = dx21i1 * dx21j2 - dx21i2 * dx21j1;

                  if (w2 < dc0)
                    w1 = -dc2 - w1;

                  if (w1 >= w1max)
                  {
                    kbedge = ibedge;

                    w1max = w1;
                  }
                }
              }
            }

            ibedge = ibeibe[kbedge][1];

            if (ibedge == 0 || ibedge == jbedge)
            {
              ibeibe[jbedge][0] = kbedge;
              ibeibe[kbedge][1] = jbedge;
            }
            else
              ierr = 4;
          }
        }
        else if (ireorder == 1) //(ireorder == 1 && mmultc == 1 && nx == 3)
          ierr = 4;
      }
      else
      {
        if (ibepn == 1)
        {
          ibeibe[jbedge][0] = kbedge;
          ibeibe[kbedge][1] = jbedge;
        }

        if (jbepn == 2)
        {
          if (mreorder == 1)
          {
            if (mben == 0)
              ireorder = 1;
            else
              ierr = 4;
          }
          else
            ierr = 5;
        }
      }

      if (ierr >= 1)
      {
        if (merr == 1)
        {
          for (loc = loc1; loc <= loc2; ++loc)
          {
            ibedge = ibein[loc];

            ierribe[ibedge] = -1;
          }
        }
        else
        {
          ug_error_message ("*** ERROR 204 : boundary edge ordering is wrong ***");
          return (204);
        }
      }
    }
 
    if (ierr == 1)
    {
      ug_error_message ("*** ERROR 200201 : multiply connected boundary edge connectivity is wrong ***");
      return (200201);
    }

    if (ierr == 2)
    {
      ug_error_message ("*** ERROR 200202 : multiply connected boundary edges found ***");
      return (200202);
    }

    if (ierr == 3)
    {
      ug_error_message ("*** ERROR 200214 : boundary edges not ordered correctly ***");
      ug_error_message ("*** multiply connected boundary edges can not be reordered ***");

      return (200214);
    }

    if (ierr == 4)
    {
      ug_error_message ("*** ERROR 200215 : boundary edges not ordered correctly ***");
      ug_error_message ("*** multiply connected boundary edges can not be reordered ***");

      return (200215);
    }

    if (ierr == 5)
    {
      ug_error_message ("*** ERROR 200216 : boundary edges not ordered correctly ***");
      return (200216);
    }

    if (ireorder == 1)
    {
      for (ibedge = 1; ibedge <= nbedge; ++ibedge)
      {
        mchkbe[ibedge] = 1;

        ibeibe[ibedge][0] = 0;
        ibeibe[ibedge][1] = 0;
      }

      ierr = 0;

      for (jbedge = 1; jbedge <= nbedge; ++jbedge)
      {
        ibepn = 0;

        iben = mchkbe[jbedge];

        jnode2 = inibe[jbedge][iben];

        loc1 = libein[jnode2];
        loc2 = libein[jnode2+1] - 1;

        for (loc = loc1; loc <= loc2; ++loc)
        {
          ibedge = ibein[loc];

          if (ibedge != jbedge)
          {
            inode1 = inibe[ibedge][0];
            inode2 = inibe[ibedge][1];

            if (inode1 == jnode2 || inode2 == jnode2)
            {
              ++ibepn;

              if (ibepn == 1)
                kbedge = ibedge;
              else
              {
                if (merr == 1)
                {
                  ierr = 1;

                  ierribe[ibedge] = -1;
                }
                else
                {
                  ug_error_message ("*** ERROR 205 : duplicate boundary edges found ***");
                  return (205);
                }
              }
            }
          }
        }

        if (ibepn == 1)
        {
          if (inibe[kbedge][0] == jnode2)
            ibeibe[kbedge][1] = jbedge;
          else
          {
            ibeibe[kbedge][0] = jbedge;

            mchkbe[kbedge] = 0;
          }

          iben = (iben == 1) ? 0 : 1;

          ibeibe[jbedge][iben] = kbedge;
        }
        else
        {
          if (ibepn == 0)
          {
            ierr = 2;

            if (merr == 1)
              ierribe[jbedge] = -1;
            else
            {
              ug_error_message ("*** ERROR 206 : duplicate boundary edges found ***");
              return (206);
            }
          }
        }
      }

      if (ierr == 1)
      {
        ug_error_message ("*** ERROR 200203 : boundary edges not ordered correctly ***");
        ug_error_message ("*** multiply connected boundary edges can not be reordered ***");
        return (200203);
      }


      if (ierr == 2)
      {
        ug_error_message ("*** ERROR 200204 : reordered boundary edge found without neighbor ***");
        return (200204);
      }

      if (mmsg == 2)
      {
        snprintf (Text, sizeof(Text), "Re-ordering B-Edges: B-Edges           =%10i", (int) nbedge);
        ug_message (Text);
      }

      for (ibedge = 1; ibedge <= nbedge; ++ibedge)
      {
        mchkbe[ibedge] = 0;
      }

      irbedge = 0;

      iboit = 1;

      do
      {
        ibedge = 0;

        do
        {
          ++ibedge;

          mchkbei = mchkbe[ibedge];
        }
        while (ibedge < nbedge && mchkbei != 0);

        if (mchkbei == 0)
        {
          mchkbe[ibedge] = 1;

          kbedge = ibedge;

          ibeit = 1;

          do
          {
            jbedge = ibedge;

            ibedge = ibeibe[jbedge][0];

            if (ibedge != kbedge)
            {
              mchkbe[ibedge] = 1;

              ibedge1 = ibeibe[ibedge][0];
              ibedge2 = ibeibe[ibedge][1];

              if (ibedge1 == jbedge)
              {
                ++irbedge;

                inode1 = inibe[ibedge][0];
                inode2 = inibe[ibedge][1];

                inibe[ibedge][0] = inode2;
                inibe[ibedge][1] = inode1;

                ibeibe[ibedge][0] = ibedge2;
                ibeibe[ibedge][1] = ibedge1;
              }
              else
              {
                if (ibedge2 != jbedge)
                {
                  if (merr == 1)
                  {
                    ierribe[ibedge] = -1;
                    ierribe[jbedge] = -1;

                    ug_error_message ("*** ERROR 200205 : boundary edge connectivity is not valid ***");
                    return (200205);
                  }
                  else
                  {
                    ug_error_message ("*** ERROR 207 : boundary edge connectivity is not valid ***");
                    return (207);
                  }
                }
              }
            }

            ++ibeit;
          }
          while (ibeit <= nbedge && ibedge != kbedge);

          if (ibedge != kbedge)
          {
            if (merr == 1)
            {
              ierribe[ibedge] = -1;
              ierribe[kbedge] = -1;
 
              ug_error_message ("*** ERROR 200206 : boundary edge connectivity is not valid ***");
              return (200206);
            }
            else
            {
              ug_error_message ("*** ERROR 208 : boundary edge connectivity is not valid ***");
              return (208);
            }
          }
        }

        ++iboit;
      }
      while (iboit <= nbedge && mchkbei == 0);

      if (mmsg == 2)
      {
        snprintf (Text, sizeof(Text), "Re-ordering B-Edges: Re-ordered B-Edges=%10i", (int) irbedge);
        ug_message (Text);
      }
    }
  }
  
  return (0);

}
