#include "UG2_LIB.h"

void ug2_fe_met_area
 (INT_ nelem,
  INT_3D * iniel,
  DOUBLE_2D * x,
  DOUBLE_2X2 * met,
  DOUBLE_1D * area)

{

/*
 * Determine metric terms and element area.
 *
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_fe_met_area.c,v 1.7 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ ielem, inode1, inode2, inode3;

  double dc1, dc1d2, dx311, dx312, dx321, dx322, met11, met12, met21, met22,
         areai, w, x11, x12, x21, x22, x31, x32;

  dc1 = 1.0;
  dc1d2 = 0.5;

  for (ielem = 1; ielem <= nelem; ++ielem)
  {
    inode1 = iniel[ielem][0];
    inode2 = iniel[ielem][1];
    inode3 = iniel[ielem][2];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x21 = x[inode2][0];
    x22 = x[inode2][1];
    x31 = x[inode3][0];
    x32 = x[inode3][1];

    dx311 = x31 - x11;
    dx312 = x32 - x12;
    dx321 = x31 - x21;
    dx322 = x32 - x22;

    areai = dx311 * dx322 - dx312 * dx321;

    w = dc1 / areai;

    met11 = - w * dx322;
    met12 = w * dx321;
    met21 = w * dx312;
    met22 = - w * dx311;

    met[ielem][0][0] = met11;
    met[ielem][0][1] = met12;
    met[ielem][1][0] = met21;
    met[ielem][1][1] = met22;

    area[ielem] = dc1d2 * areai;
  }

  return;

}
