#include "UG2_LIB.h"

void ug2_fe_gradu
 (INT_ nelem,
  INT_ nnode,
  INT_3D * iniel,
  DOUBLE_1D * area,
  DOUBLE_1D * areasumr,
  DOUBLE_2X2 * met,
  DOUBLE_1D * u,
  DOUBLE_2D * gradu)

{

/*
 * Determine gradient of a function.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_fe_gradu.c,v 1.8 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ ielem, inode, inode1, inode2, inode3;

  double areai, areasumri, dc0, dc1, gradu1, gradu2, met11, met12, met21, met22,
         met31, met32, u1, u2, u3;

  dc0 = 0.0;
  dc1 = 1.0;

  if (areasumr[1] <= dc0)
  {
    for (inode = 1; inode <= nnode; ++inode)
    {
      areasumr[inode] = dc0;
    }

    for (ielem = 1; ielem <= nelem; ++ielem)
    {
      inode1 = iniel[ielem][0];
      inode2 = iniel[ielem][1];
      inode3 = iniel[ielem][2];

      areai = area[ielem];

      areasumr[inode1] = areasumr[inode1] + areai;
      areasumr[inode2] = areasumr[inode2] + areai;
      areasumr[inode3] = areasumr[inode3] + areai;
    }

    for (inode = 1; inode <= nnode; ++inode)
    {
      areasumr[inode] = dc1 / areasumr[inode];
    }
  }

  for (inode = 1; inode <= nnode; ++inode)
  {
    gradu[inode][0] = dc0;
    gradu[inode][1] = dc0;
  }

  for (ielem = 1; ielem <= nelem; ++ielem)
  {
    inode1 = iniel[ielem][0];
    inode2 = iniel[ielem][1];
    inode3 = iniel[ielem][2];

    u1 = u[inode1];
    u2 = u[inode2];
    u3 = u[inode3];

    met11 = met[ielem][0][0];
    met12 = met[ielem][0][1];
    met21 = met[ielem][1][0];
    met22 = met[ielem][1][1];
    met31 = - met11 - met21;
    met32 = - met12 - met22;

    areai = area[ielem];

    gradu1 = (u1 * met11 + u2 * met21 + u3 * met31) * areai;
    gradu2 = (u1 * met12 + u2 * met22 + u3 * met32) * areai;

    gradu[inode1][0] = gradu[inode1][0] + gradu1;
    gradu[inode1][1] = gradu[inode1][1] + gradu2;
    gradu[inode2][0] = gradu[inode2][0] + gradu1;
    gradu[inode2][1] = gradu[inode2][1] + gradu2;
    gradu[inode3][0] = gradu[inode3][0] + gradu1;
    gradu[inode3][1] = gradu[inode3][1] + gradu2;
  }

  for (inode = 1; inode <= nnode; ++inode)
  {
    areasumri = areasumr[inode];

    gradu[inode][0] = areasumri * gradu[inode][0];
    gradu[inode][1] = areasumri * gradu[inode][1];
  }

  return;

}
