#include "UG2_LIB.h"

INT_ ug2_extract_edge
 (INT_ igroup,
  INT_ nbedge_global,
  INT_ nnode_global,
  INT_ *nbedge,
  INT_ *nnode,
  INT_1D * ibcibe_global,
  INT_1D * idibe_global,
  INT_1D * igibe_global,
  INT_2D * inibe_global,
  INT_1D ** ibcibe,
  INT_1D ** idibe,
  INT_2D ** inibe,
  DOUBLE_1D * del_global,
  DOUBLE_1D * ds_global,
  DOUBLE_2D * x_global,
  DOUBLE_1D ** del,
  DOUBLE_1D ** ds,
  DOUBLE_2D ** x)

{

/*
 * Extract a boundary edge grid portion from a given global boundary edge grid.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_extract_edge.c,v 1.8 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_1D *inin_global = NULL;

  INT_ ibedge, inode, jbedge, jnode, jnode1, jnode2;
  INT_ ierr = 0;

  *nbedge = 0;
  *nnode = 0;

  *ibcibe = NULL;
  *idibe = NULL;
  *inibe = NULL;
  *x = NULL;

  if (ibcibe_global)
    *ibcibe = (INT_1D *) ug_malloc (&ierr, (nbedge_global+1) * sizeof (INT_1D));
  if (idibe_global)
    *idibe = (INT_1D *) ug_malloc (&ierr, (nbedge_global+1) * sizeof (INT_1D));
  *inibe = (INT_2D *) ug_malloc (&ierr, (nbedge_global+1) * sizeof (INT_2D));
  *x = (DOUBLE_2D *) ug_malloc (&ierr, (nnode_global+1) * sizeof (DOUBLE_2D));

  inin_global = (INT_1D *) ug_malloc (&ierr, (nnode_global+1) * sizeof (INT_1D));

  if (ierr)
  {
    ug_free (inin_global);
    ug_error_message ("*** ERROR 100210 : unable to allocate required memory ***");
    return (100210);
  }

  for (jnode = 1; jnode <= nnode_global; ++jnode)
  {
    inin_global[jnode] = 0;
  }

  ibedge = 0;

  for (jbedge = 1; jbedge <= nbedge_global; ++jbedge)
  {
    if (igibe_global[jbedge] == igroup)
    {
      ++ibedge;

      jnode1 = inibe_global[jbedge][0];
      jnode2 = inibe_global[jbedge][1];

      inin_global[jnode1] = 1;
      inin_global[jnode2] = 1;

      (*inibe)[ibedge][0] = jnode1;
      (*inibe)[ibedge][1] = jnode2;

      if (ibcibe_global)
        (*ibcibe)[ibedge] = ibcibe_global[jbedge];

      if (idibe_global)
        (*idibe)[ibedge] = idibe_global[jbedge];
    }
  }

  *nbedge = ibedge;

  inode = 0;

  for (jnode = 1; jnode <= nnode_global; ++jnode)
  {
    if (inin_global[jnode])
    {
      ++inode;

      inin_global[jnode] = inode;

      (*x)[inode][0] = x_global[jnode][0];
      (*x)[inode][1] = x_global[jnode][1];

      if (*del && del_global)
        (*del)[inode] = del_global[jnode];

      if (*ds && ds_global)
        (*ds)[inode] = ds_global[jnode];
    }
  }

  *nnode = inode;

  for (ibedge = 1; ibedge <= *nbedge; ++ibedge)
  {
    jnode1 = (*inibe)[ibedge][0];
    jnode2 = (*inibe)[ibedge][1];

    (*inibe)[ibedge][0] = inin_global[jnode1];
    (*inibe)[ibedge][1] = inin_global[jnode2];
  }

  ug_free (inin_global);

  if (ibcibe_global)
    *ibcibe = (INT_1D *) ug_realloc (&ierr, *ibcibe, ((*nbedge)+1) * sizeof (INT_1D));
  if (idibe_global)
    *idibe = (INT_1D *) ug_realloc (&ierr, *idibe, ((*nbedge)+1) * sizeof (INT_1D));
  *inibe = (INT_2D *) ug_realloc (&ierr, *inibe, ((*nbedge)+1) * sizeof (INT_2D));
  *x = (DOUBLE_2D *) ug_realloc (&ierr, *x, ((*nnode)+1) * sizeof (DOUBLE_2D));

  if (ierr)
  {
    ug_error_message ("*** ERROR 100211 : unable to allocate required memory ***");
    return (100211);
  }

  return (0);

}
