#include "UG2_LIB.h"

double ug2_dx
 (INT_ nnode,
  DOUBLE_2D * x)

{

/*
 * Determine maximum dimension for a set of nodes.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_dx.c,v 1.6 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ inode;

  double dx, dx1, dx2, x1, x1max, x1min, x2, x2max, x2min;

  inode = 1;

  x1 = x[inode][0];
  x2 = x[inode][1];

  x1max = x1;
  x2max = x2;
  x1min = x1;
  x2min = x2;

  for (inode = 2; inode <= nnode; ++inode)
  {
    x1 = x[inode][0];
    x2 = x[inode][1];

    x1max = MAX (x1max, x1);
    x2max = MAX (x2max, x2);
    x1min = MIN (x1min, x1);
    x2min = MIN (x2min, x2);
  }

  dx1 = x1max - x1min;
  dx2 = x2max - x2min;

  dx = MAX (dx1, dx2);

  return (dx);

}
