#include "UG2_LIB.h"

void ug2_dfmax
 (INT_ nbedge,
  INT_ nnode,
  INT_2D * inibe,
  double cdf,
  DOUBLE_2D * x,
  DOUBLE_1D * dfmax)

{

/*
 * Determine the local maximum distribution function at all boundary nodes.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_dfmax.c,v 1.4 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ ibedge, inode, inode1, inode2;

  double dc0, dss, dx1, dx2, x11, x12, x21, x22;

  dc0 = 0.0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    dfmax[inode] = dc0;
  }

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    inode1 = inibe[ibedge][0];
    inode2 = inibe[ibedge][1];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x21 = x[inode2][0];
    x22 = x[inode2][1];

    dx1 = x21 - x11;
    dx2 = x22 - x12;

    dss = dx1 * dx1 + dx2 * dx2;

    dfmax[inode1] = MAX (dfmax[inode1], dss);
    dfmax[inode2] = MAX (dfmax[inode2], dss);
  }

  for (inode = 1; inode <= nnode; ++inode)
  {
    dfmax[inode] = cdf * sqrt (dfmax[inode]);
  }

  return;

}
