#include "UG2_LIB.h"

void ug2_dff
 (INT_ nbedge,
  INT_ nelem,
  INT_ nnode,
  INT_ nnodeb,
  INT_2D * inibe,
  INT_3D * iniel,
  INT_1D * nnp,
  double cdf,
  DOUBLE_2D * x,
  DOUBLE_1D * df)

{

/*
 * Determine the distribution function (df) at all nodes.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_dff.c,v 1.7 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ ibedge, ielem, inode, inode1, inode2, inode3, nnpi;

  double dc0, df1, df2, df3, dx1, dx2, x11, x12, x21, x22, x31, x32;

  dc0 = 0.0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    nnp[inode] = 1;

    df[inode] = dc0;
  }

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    inode1 = inibe[ibedge][0];
    inode2 = inibe[ibedge][1];

    nnp[inode1] = 0;
    nnp[inode2] = 0;
  }

  for (ielem = 1; ielem <= nelem; ++ielem)
  {
    inode1 = iniel[ielem][0];
    inode2 = iniel[ielem][1];
    inode3 = iniel[ielem][2];

    if (inode1 > nnodeb && inode2 > nnodeb && inode3 > nnodeb)
    {
      nnp[inode1] = 0;
      nnp[inode2] = 0;
      nnp[inode3] = 0;
    }
  }

  inode = 1;

  do
  {
    nnpi = nnp[inode];

    ++inode;
  }
  while (inode <= nnode && nnpi == 0);

  if (nnpi == 1)
  {
    for (ibedge = 1; ibedge <= nbedge; ++ibedge)
    {
      inode1 = inibe[ibedge][0];
      inode2 = inibe[ibedge][1];

      x11 = x[inode1][0];
      x12 = x[inode1][1];
      x21 = x[inode2][0];
      x22 = x[inode2][1];

      dx1 = x21 - x11;
      dx2 = x22 - x12;

      df1 = sqrt (dx1 * dx1 + dx2 * dx2);

      df[inode1] = df[inode1] + df1;
      df[inode2] = df[inode2] + df1;

      nnp[inode1] = nnp[inode1] + 1;
      nnp[inode2] = nnp[inode2] + 1;
    }

    for (inode = 1; inode <= nnodeb; ++inode)
    {
      df[inode] = df[inode] / ((double) nnp[inode]);
    }
  }

  else
  {
    for (ielem = 1; ielem <= nelem; ++ielem)
    {
      inode1 = iniel[ielem][0];
      inode2 = iniel[ielem][1];
      inode3 = iniel[ielem][2];

      x11 = x[inode1][0];
      x12 = x[inode1][1];
      x21 = x[inode2][0];
      x22 = x[inode2][1];
      x31 = x[inode3][0];
      x32 = x[inode3][1];

      dx1 = x21 - x11;
      dx2 = x22 - x12;

      df1 = sqrt (dx1 * dx1 + dx2 * dx2);

      dx1 = x31 - x11;
      dx2 = x32 - x12;

      df2 = sqrt (dx1 * dx1 + dx2 * dx2);

      dx1 = x31 - x21;
      dx2 = x32 - x22;

      df3 = sqrt (dx1 * dx1 + dx2 * dx2);

      df[inode1] = df[inode1] + df1 + df2;
      df[inode2] = df[inode2] + df1 + df3;
      df[inode3] = df[inode3] + df2 + df3;

      nnp[inode1] = nnp[inode1] + 2;
      nnp[inode2] = nnp[inode2] + 2;
      nnp[inode3] = nnp[inode3] + 2;
    }

    for (inode = 1; inode <= nnode; ++inode)
    {
      df[inode] = cdf * df[inode] / ((double) nnp[inode]);
    }
  }

  return;

}
