#include "UG2_LIB.h"

void ug2_df0f
 (INT_ nnode,
  INT_1D * ielin,
  INT_3D * iniel,
  INT_1D * lielin,
  INT_1D * mn,
  DOUBLE_1D * df)

{

/*
 * Set zero value distribution function using simple averaging.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_df0f.c,v 1.7 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ ielem, iit, inode, inode1, inode2, inode3, loc, loc1, loc2, nit, mn1,
       mn2, mn3, mni, mnmax, mnmin;

  double dc0, dc1, dfsum, wsum;

  dc0 = 0.0;
  dc1 = 1.0;

  mnmax = 0;
  mnmin = 1;

  for (inode = 1; inode <= nnode; ++inode)
  {
    if (df[inode] == dc0)
    {
      mnmin = 0;

      mn[inode] = 0;
    }
    else
    {
      mnmax = 1;

      mn[inode] = 1;
    }
  }

  if (mnmax == 0 || mnmin == 1) return;

  nit = nnode;

  iit = 1;

  do
  {
    mnmin = 1;

    for (inode = 1; inode <= nnode; ++inode)
    {
      mni = mn[inode];

      if (mni == 0)
      {
        dfsum = dc0;

        wsum = dc0;

        loc1 = lielin[inode];
        loc2 = lielin[inode+1] - 1;

        for (loc = loc1; loc <= loc2; ++loc)
        {
          ielem = ielin[loc];

          inode1 = iniel[ielem][0];
          inode2 = iniel[ielem][1];
          inode3 = iniel[ielem][2];

          mn1 = mn[inode1];
          mn2 = mn[inode2];
          mn3 = mn[inode3];

          if (mn1 == 1 || mn2 == 1 || mn3 == 1)
          {
            mni = -1;

            if (mn1 == 1)
            {
              dfsum = dfsum + df[inode1];

              wsum = wsum + dc1;
            }

            if (mn2 == 1)
            {
              dfsum = dfsum + df[inode2];

              wsum = wsum + dc1;
            }

            if (mn3 == 1)
            {
              dfsum = dfsum + df[inode3];

              wsum = wsum + dc1;
            }
          }
        }
      }

      if (mni == 0)
        mnmin = 0;

      else if (mni == -1)
      {
        mn[inode] = 1;

        df[inode] = dfsum / wsum;
      }
    }

    ++iit;
  }
  while (iit <= nit && mnmin == 0);

  return;

}
