#include "UG2_LIB.h"

void ug2_df
 (INT_ nbedge,
  INT_ nnode,
  INT_2D * inibe,
  INT_1D * nnp,
  double cdf,
  DOUBLE_2D * x,
  DOUBLE_1D * df)

{

/*
 * Determine the distribution function (df) at all boundary nodes.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_df.c,v 1.7 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ ibedge, inode, inode1, inode2;

  double dc0, df0, dx1, dx2, x11, x12, x21, x22;

  dc0 = 0.0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    nnp[inode] = 1;

    df[inode] = dc0;
  }

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    inode1 = inibe[ibedge][0];
    inode2 = inibe[ibedge][1];

    nnp[inode1] = 0;
    nnp[inode2] = 0;
  }

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    inode1 = inibe[ibedge][0];
    inode2 = inibe[ibedge][1];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x21 = x[inode2][0];
    x22 = x[inode2][1];

    dx1 = x21 - x11;
    dx2 = x22 - x12;

    df0 = sqrt (dx1 * dx1 + dx2 * dx2);

    df[inode1] = df[inode1] + df0;
    df[inode2] = df[inode2] + df0;

    nnp[inode1] = nnp[inode1] + 1;
    nnp[inode2] = nnp[inode2] + 1;
  }

  for (inode = 1; inode <= nnode; ++inode)
  {
    df[inode] = cdf * df[inode] / (double)(nnp[inode]);
  }

  return;

}
