#include "UG2_LIB.h"

void ug2_cv_gradu
 (INT_ nbedge,
  INT_ nedge,
  INT_ nnode,
  INT_2D * inibe,
  INT_2D * inie,
  DOUBLE_1D * cv_area,
  DOUBLE_2D * cv_csv,
  DOUBLE_1D * u,
  DOUBLE_2D * x,
  DOUBLE_2D * gradu)

{

/*
 * Determine gradient of a function.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_cv_gradu.c,v 1.6 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ ibedge, iedge, inode, inode1, inode2;

  double cv_csv1, cv_csv2, dc0, dc1, dc5, dc6, dc1d2, dc1d6, dc5d6, flux1,
         flux2, u1, u2, uavg, uavg1, uavg2, w, x11, x12, x21, x22;

  dc0 = 0.0;
  dc1 = 1.0;
  dc5 = 5.0;
  dc6 = 6.0;
  dc1d2 = 0.5;
  dc1d6 = dc1 / dc6;
  dc5d6 = dc5 / dc6;

  for (inode = 1; inode <= nnode; ++inode)
  {
    gradu[inode][0] = dc0;
    gradu[inode][1] = dc0;
  }

  for (iedge = 1; iedge <= nedge; ++iedge)
  {
    inode1 = inie[iedge][0];
    inode2 = inie[iedge][1];

    u1 = u[inode1];
    u2 = u[inode2];

    uavg = u1 + u2;

    flux1 = uavg * cv_csv[iedge][0];
    flux2 = uavg * cv_csv[iedge][1];

    gradu[inode1][0] = gradu[inode1][0] + flux1;
    gradu[inode1][1] = gradu[inode1][1] + flux2;
    gradu[inode2][0] = gradu[inode2][0] - flux1;
    gradu[inode2][1] = gradu[inode2][1] - flux2;
  }

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    inode1 = inibe[ibedge][0];
    inode2 = inibe[ibedge][1];

    u1 = u[inode1];
    u2 = u[inode2];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x21 = x[inode2][0];
    x22 = x[inode2][1];

    cv_csv1 = x22 - x12;
    cv_csv2 = x11 - x21;

    uavg1 = dc5d6 * u1 + dc1d6 * u2;
    uavg2 = dc1d6 * u1 + dc5d6 * u2;

    gradu[inode1][0] = gradu[inode1][0] + uavg1 * cv_csv1;
    gradu[inode1][1] = gradu[inode1][1] + uavg1 * cv_csv2;
    gradu[inode2][0] = gradu[inode2][0] + uavg2 * cv_csv1;
    gradu[inode2][1] = gradu[inode2][1] + uavg2 * cv_csv2;
  }

  for (inode = 1; inode <= nnode; ++inode)
  {
    w = dc1d2 / cv_area[inode];

    gradu[inode][0] = w * gradu[inode][0];
    gradu[inode][1] = w * gradu[inode][1];
  }

  return;

}
