#include "UG2_LIB.h"

void ug2_cv_ev
 (INT_ nedge,
  INT_2D * inie,
  DOUBLE_2D * x,
  DOUBLE_1D * cv_edsr,
  DOUBLE_2D * cv_ev)

{

/*
 * Determine control volume edge length and vector terms.
 *
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_cv_ev.c,v 1.7 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ iedge, inode1, inode2;

  double cv_edsri, dc1, dx211, dx212, x11, x12, x21, x22;

  dc1 = 1.0;

  for (iedge = 1; iedge <= nedge; ++iedge)
  {
    inode1 = inie[iedge][0];
    inode2 = inie[iedge][1];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x21 = x[inode2][0];
    x22 = x[inode2][1];

    dx211 = x21 - x11;
    dx212 = x22 - x12;

    cv_edsri = dc1 / sqrt (dx211 * dx211 + dx212 * dx212);

    cv_edsr[iedge] = cv_edsri;

    cv_ev[iedge][0] = cv_edsri * dx211;
    cv_ev[iedge][1] = cv_edsri * dx212;
  }

  return;

}
