#include "UG2_LIB.h"

void ug2_cv_csv_area
 (INT_ nedge,
  INT_ nelem,
  INT_ nnode,
  INT_ nquad,
  INT_1D * iein,
  INT_2D * inie,
  INT_3D * iniel,
  INT_4D * iniq,
  INT_1D * liein,
  DOUBLE_2D * x,
  DOUBLE_1D * cv_area,
  DOUBLE_2D * cv_csv)

{

/*
 * Determine control volume area and control surface vector terms.
 *
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_cv_csv_area.c,v 1.10 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ iedge, ielem, inode, inode1, inode2, inode3, inode4, iquad, jnode1,
       jnode2, knode1, knode2, loc, loc1, loc2;

  double cv_areai, cv_csv1, cv_csv2, dc0, dc1, dc6, dc1d4, dc1d6, dc1d8, dx211,
         dx212, dx311, dx312, dx321, dx322, dx411, dx412, dx421, dx422, dx431,
         dx432, v11, v12, v21, v22, v31, v32, x11, x12, x21, x22, x31, x32, x41,
         x42;

  dc0 = 0.0;
  dc1 = 1.0;
  dc6 = 6.0;
  dc1d4 = 0.25;
  dc1d6 = dc1 / dc6;
  dc1d8 = 0.125;

  for (inode = 1; inode <= nnode; ++inode)
  {
    cv_area[inode] = dc0;
  }

  for (iedge = 1; iedge <= nedge; ++iedge)
  {
    cv_csv[iedge][0] = dc0;
    cv_csv[iedge][1] = dc0;
  }

  for (ielem = 1; ielem <= nelem; ++ielem)
  {
    inode1 = iniel[ielem][0];
    inode2 = iniel[ielem][1];
    inode3 = iniel[ielem][2];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x21 = x[inode2][0];
    x22 = x[inode2][1];
    x31 = x[inode3][0];
    x32 = x[inode3][1];

    dx211 = x21 - x11;
    dx212 = x22 - x12;
    dx311 = x31 - x11;
    dx312 = x32 - x12;

    cv_areai = dc1d6 * (dx211 * dx312 - dx212 * dx311);

    cv_area[inode1] = cv_area[inode1] + cv_areai;
    cv_area[inode2] = cv_area[inode2] + cv_areai;
    cv_area[inode3] = cv_area[inode3] + cv_areai;

    v21 = - dc1d6 * dx312;
    v22 =   dc1d6 * dx311;
    v31 =   dc1d6 * dx212;
    v32 = - dc1d6 * dx211;
    v11 = - v21 - v31;
    v12 = - v22 - v32;

    jnode1 = MIN (inode1, inode2);

    if (jnode1 == inode1)
    {
      cv_csv1 = v11 - v21;
      cv_csv2 = v12 - v22;

      jnode2 = inode2;
    }
    else
    {
      cv_csv1 = v21 - v11;
      cv_csv2 = v22 - v12;

      jnode2 = inode1;
    }

    loc1 = liein[jnode1];
    loc2 = liein[jnode1+1]-1;

    loc = loc1;

    do
    {
      iedge = iein[loc];

      knode1 = inie[iedge][0];
      knode2 = inie[iedge][1];

      ++loc;
    }
    while (loc <= loc2 && knode1 != jnode2 && knode2 != jnode2);

    cv_csv[iedge][0] = cv_csv[iedge][0] + cv_csv1;
    cv_csv[iedge][1] = cv_csv[iedge][1] + cv_csv2;

    jnode1 = MIN (inode2, inode3);

    if (jnode1 == inode2)
    {
      cv_csv1 = v21 - v31;
      cv_csv2 = v22 - v32;

      jnode2 = inode3;
    }
    else
    {
      cv_csv1 = v31 - v21;
      cv_csv2 = v32 - v22;

      jnode2 = inode2;
    }

    loc1 = liein[jnode1];
    loc2 = liein[jnode1+1]-1;

    loc = loc1;

    do
    {
      iedge = iein[loc];

      knode1 = inie[iedge][0];
      knode2 = inie[iedge][1];

      ++loc;
    }
    while (loc <= loc2 && knode1 != jnode2 && knode2 != jnode2);

    cv_csv[iedge][0] = cv_csv[iedge][0] + cv_csv1;
    cv_csv[iedge][1] = cv_csv[iedge][1] + cv_csv2;

    jnode1 = MIN (inode3, inode1);

    if (jnode1 == inode3)
    {
      cv_csv1 = v31 - v11;
      cv_csv2 = v32 - v12;

      jnode2 = inode1;
    }
    else
    {
      cv_csv1 = v11 - v31;
      cv_csv2 = v12 - v32;

      jnode2 = inode3;
    }

    loc1 = liein[jnode1];
    loc2 = liein[jnode1+1]-1;

    loc = loc1;

    do
    {
      iedge = iein[loc];

      knode1 = inie[iedge][0];
      knode2 = inie[iedge][1];

      ++loc;
    }
    while (loc <= loc2 && knode1 != jnode2 && knode2 != jnode2);

    cv_csv[iedge][0] = cv_csv[iedge][0] + cv_csv1;
    cv_csv[iedge][1] = cv_csv[iedge][1] + cv_csv2;
  }

  for (iquad = 1; iquad <= nquad; ++iquad)
  {
    inode1 = iniq[iquad][0];
    inode2 = iniq[iquad][1];
    inode3 = iniq[iquad][2];
    inode4 = iniq[iquad][3];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x21 = x[inode2][0];
    x22 = x[inode2][1];
    x31 = x[inode3][0];
    x32 = x[inode3][1];
    x41 = x[inode4][0];
    x42 = x[inode4][1];

    dx211 = x21 - x11;
    dx212 = x22 - x12;
    dx311 = x31 - x11;
    dx312 = x32 - x12;
    dx321 = x31 - x21;
    dx322 = x32 - x22;
    dx411 = x41 - x11;
    dx412 = x42 - x12;
    dx421 = x41 - x21;
    dx422 = x42 - x22;
    dx431 = x41 - x31;
    dx432 = x42 - x32;

    cv_areai = dc1d8 * (dx311 * dx422 - dx312 * dx421);

    cv_area[inode1] = cv_area[inode1] + cv_areai;
    cv_area[inode2] = cv_area[inode2] + cv_areai;
    cv_area[inode3] = cv_area[inode3] + cv_areai;
    cv_area[inode4] = cv_area[inode4] + cv_areai;

    v11 = dc1d4 * (dx412 + dx322);
    v12 = - dc1d4 * (dx411 + dx321);
    v21 = - dc1d4 * (dx212 - dx432);
    v22 = dc1d4 * (dx211 - dx431);

    jnode1 = MIN (inode1, inode2);

    if (jnode1 == inode1)
    {
      cv_csv1 = v11;
      cv_csv2 = v12;

      jnode2 = inode2;
    }
    else
    {
      cv_csv1 = - v11;
      cv_csv2 = - v12;

      jnode2 = inode1;
    }

    loc1 = liein[jnode1];
    loc2 = liein[jnode1+1]-1;

    loc = loc1;

    do
    {
      iedge = iein[loc];

      knode1 = inie[iedge][0];
      knode2 = inie[iedge][1];

      ++loc;
    }
    while (loc <= loc2 && knode1 != jnode2 && knode2 != jnode2);

    cv_csv[iedge][0] = cv_csv[iedge][0] + cv_csv1;
    cv_csv[iedge][1] = cv_csv[iedge][1] + cv_csv2;

    jnode1 = MIN (inode2, inode3);

    if (jnode1 == inode2)
    {
      cv_csv1 = v21;
      cv_csv2 = v22;

      jnode2 = inode3;
    }
    else
    {
      cv_csv1 = - v21;
      cv_csv2 = - v22;

      jnode2 = inode2;
    }

    loc1 = liein[jnode1];
    loc2 = liein[jnode1+1]-1;

    loc = loc1;

    do
    {
      iedge = iein[loc];

      knode1 = inie[iedge][0];
      knode2 = inie[iedge][1];

      ++loc;
    }
    while (loc <= loc2 && knode1 != jnode2 && knode2 != jnode2);

    cv_csv[iedge][0] = cv_csv[iedge][0] + cv_csv1;
    cv_csv[iedge][1] = cv_csv[iedge][1] + cv_csv2;

    jnode1 = MIN (inode3, inode4);

    if (jnode1 == inode3)
    {
      cv_csv1 = - v11;
      cv_csv2 = - v12;

      jnode2 = inode4;
    }
    else
    {
      cv_csv1 = v11;
      cv_csv2 = v12;

      jnode2 = inode3;
    }

    loc1 = liein[jnode1];
    loc2 = liein[jnode1+1]-1;

    loc = loc1;

    do
    {
      iedge = iein[loc];

      knode1 = inie[iedge][0];
      knode2 = inie[iedge][1];

      ++loc;
    }
    while (loc <= loc2 && knode1 != jnode2 && knode2 != jnode2);

    cv_csv[iedge][0] = cv_csv[iedge][0] + cv_csv1;
    cv_csv[iedge][1] = cv_csv[iedge][1] + cv_csv2;

    jnode1 = MIN (inode4, inode1);

    if (jnode1 == inode4)
    {
      cv_csv1 = - v21;
      cv_csv2 = - v22;

      jnode2 = inode1;
    }
    else
    {
      cv_csv1 = v21;
      cv_csv2 = v22;

      jnode2 = inode4;
    }

    loc1 = liein[jnode1];
    loc2 = liein[jnode1+1]-1;

    loc = loc1;

    do
    {
      iedge = iein[loc];

      knode1 = inie[iedge][0];
      knode2 = inie[iedge][1];

      ++loc;
    }
    while (loc <= loc2 && knode1 != jnode2 && knode2 != jnode2);

    cv_csv[iedge][0] = cv_csv[iedge][0] + cv_csv1;
    cv_csv[iedge][1] = cv_csv[iedge][1] + cv_csv2;
  }

  return;

}
