#include "UG2_LIB.h"

INT_ ug2_chkq
 (INT_ mmsg,
  INT_ nelem,
  INT_3D * iniel,
  INT_1D * ierriel,
  double angqmax,
  DOUBLE_2D * x)

{

/*
 * Check angles of each triangular element.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_chkq.c,v 1.14 2022/11/21 00:11:08 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 * 
 */

  CHAR_133 Text;

  INT_ ielem, ierr, inode1, inode2, inode3;

  double cosqmax, cosqmaxs, dc0, dc1, dc45,
         dx211, dx212, dx21s, dx311, dx312, dx31s, dx321, dx322, dx32s,
         w, w1, w2, w3, x11, x12, x21, x22, x31, x32;

  dc0 = 0.0;
  dc1 = 1.0;
  dc45 = 45.0;

  if (angqmax == dc0)
    return (0);

  if (mmsg == 2)
  {
    snprintf (Text, sizeof(Text), "Checking Max-Angle : Elements          =%10i", (int) nelem);
    ug_message (Text);
  }

  cosqmax = cos (angqmax * atan (dc1) / dc45);
  cosqmaxs = cosqmax * fabs (cosqmax);

  if (ierriel)
  {
    for (ielem = 1; ielem <= nelem; ++ielem)
    {
      ierriel[ielem] = 0;
    }
  }

  ierr = 0;

  ielem = 1;

  do
  {
    inode1 = iniel[ielem][0];
    inode2 = iniel[ielem][1];
    inode3 = iniel[ielem][2];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x21 = x[inode2][0];
    x22 = x[inode2][1];
    x31 = x[inode3][0];
    x32 = x[inode3][1];

    dx211 = x21 - x11;
    dx212 = x22 - x12;
    dx311 = x31 - x11;
    dx312 = x32 - x12;
    dx321 = x31 - x21;
    dx322 = x32 - x22;

    dx21s = dx211 * dx211 + dx212 * dx212;
    dx31s = dx311 * dx311 + dx312 * dx312;
    dx32s = dx321 * dx321 + dx322 * dx322;

    if (dx21s > dc0 && dx31s > dc0 && dx32s > dc0)
    {
      w1 =   dx211 * dx311 + dx212 * dx312;
      w2 = - dx211 * dx321 - dx212 * dx322;
      w3 =   dx321 * dx311 + dx322 * dx312;

      w1 = cosqmaxs * dx21s * dx31s - w1 * fabs (w1);
      w2 = cosqmaxs * dx21s * dx32s - w2 * fabs (w2);
      w3 = cosqmaxs * dx32s * dx31s - w3 * fabs (w3);

      w = MAX (w1, w2);
      w = MAX (w3, w);
    }
    else
      w = dc1;

    if (w > dc0)
    {
      ierr = 1;

      if (ierriel)
        ierriel[ielem] = -1;
    }

    ++ielem;
  }
  while (ielem <= nelem && (! ierr || ierriel));

  if (ierr)
  {
    ug_error_message ("*** ERROR 212 : found element with poor quality ***");
    return (212);
  }

  if (mmsg == 2)
  {
    snprintf (Text, sizeof(Text), "Checking Max-Angle : All Angles       <=%10g", angqmax);
    ug_message (Text);
  }

  return (0);
}
