#include "UG2_LIB.h"

INT_ ug2_chkgrid
 (INT_ mmsg,
  INT_ mreorder,
  INT_ nelem,
  INT_ nnode,
  INT_3D * iniel)

{

/*
 * Reorder element connectivity if it is not consistently ordered and check
 * element neighbors and connectivity.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_chkgrid.c,v 1.6 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_1D *ielichk, *ielin, *lielin, *mchkel;
  INT_1D *madd = NULL;

  INT_3D *ieliel;

  DOUBLE_2D *x = NULL;

  INT_ ielem0, ierr, mareachk, nelpn, nelpntd, nelpnt;

  double tol = 0.0;

  ielem0 = 1;
  ierr = 0;
  nelpn = 7;
  mareachk = 0;

  ieliel = NULL;
  ielichk = NULL;
  ielin = NULL;
  lielin = NULL;
  madd = NULL;
  mchkel = NULL;

  nelpntd = nnode * nelpn;

  ieliel = (INT_3D *) ug_malloc (&ierr, (nelem+1) * sizeof (INT_3D));

  ielichk = (INT_1D *) ug_malloc (&ierr, (nelem+1) * sizeof (INT_1D));
  ielin = (INT_1D *) ug_malloc (&ierr, (nelpntd+1) * sizeof (INT_1D));
  lielin = (INT_1D *) ug_malloc (&ierr, (nnode+2) * sizeof (INT_1D));
  mchkel = (INT_1D *) ug_malloc (&ierr, (nelem+1) * sizeof (INT_1D));

  if (ierr > 0)
  {
    ug_error_message ("*** ERROR 100207 : unable to allocate required memory ***");
    ug_free (ieliel);
    ug_free (ielichk);
    ug_free (ielin);
    ug_free (lielin);
    ug_free (mchkel);
    return (100207);
  }

  ierr = ug2_ielin (ielem0, nelem, &nelpntd, nnode, &nelpnt,
                    iniel, madd,
                    &ielin, lielin);

  if (ierr > 0)
  {
    ug_free (ieliel);
    ug_free (ielichk);
    ug_free (ielin);
    ug_free (lielin);
    ug_free (mchkel);
    return (ierr);
  }

  ierr = ug2_ieliel2 (mmsg, mreorder, nelem,
                      ielin, iniel, lielin, ielichk, mchkel, ieliel);

  ug_free (ielichk);
  ug_free (ielin);
  ug_free (lielin);
  ug_free (mchkel);

  if (ierr > 0)
  {
    ug_free (ieliel);
    return (ierr);
  }

  ierr = ug2_chk (mmsg, mareachk, nelem, nnode, ieliel, iniel, tol, x);

  ug_free (ieliel);

  if (ierr > 0)
    return (ierr);

  return (0);
}
