#include "UG2_LIB.h"

INT_ ug2_chkbn
 (INT_ merr,
  INT_ mmsg,
  INT_ nbedge,
  INT_ nnode,
  INT_2D * inibe,
  INT_1D * mchkbn,
  INT_1D * ierribe)
{

/*
 * Check that all nodes are on a boundary surface and that all edges reference
 * included nodes.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_chkbn.c,v 1.17 2022/11/21 00:11:08 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  CHAR_133 Text;

  INT_ i, ibedge, ierror, inode, inode1, inode2, n;

  if (mmsg == 2)
  {
    snprintf (Text, sizeof(Text), "Checking B-Nodes   : Nodes             =%10i", (int) nnode);
    ug_message (Text);
  }

  ierror = 0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    mchkbn[inode] = 1;
  }

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    inode1 = inibe[ibedge][0];
    inode2 = inibe[ibedge][1];

    if (inode1 > nnode)
    {
      ierror = 1;

      if (merr == 1) ierribe[ibedge] = -1;
    }
    else
      mchkbn[inode1] = 0;

    if (inode2 > nnode)
    {
      ierror = 1;

      if (merr == 1) ierribe[ibedge] = -1;
    }
    else
      mchkbn[inode2] = 0;
  }

  if (ierror == 1)
  {
    if (merr == 1)
    {
      ug_error_message ("*** ERROR 200210 : boundary edge found with a node that is not specified ***");
      return (200210);
    }
    else
    {
      ug_error_message ("*** ERROR 210 : boundary edge found with a node that is not specified ***");
      return (210);
    }
  }

  if (mmsg == 2)
    ug_message ("Checking B-Nodes   : All faces reference included nodes");

  for (inode = 1; inode <= nnode; ++inode)
  {
    if (mchkbn[inode] == 1)
      ierror = 1;
  }

  if (ierror == 1)
  {
    if (merr == 1)
    {
      n = MIN (nnode, nbedge);

      i = 0;

      for (inode = 1; inode <= nnode; ++inode)
      {
        if (mchkbn[inode] == 1)
	{
          ++i;

	  if (i <= n)
            ierribe[i] = inode;
	}
      }

      ug_error_message ("*** ERROR 200211 : found nodes that are not included in boundary edge connectivity ***");
      ug_error_message ("*** edge grid may have an extra or duplicate node ***");

      return (200211);
    }
    else
    {
      ug_error_message ("*** ERROR 211 : found nodes that are not included in boundary edge connectivity ***");
      ug_error_message ("*** edge grid may have an extra or duplicate node ***");

      return (211);
    }
  }

  if (mmsg == 2)
    ug_message ("Checking B-Nodes   : All nodes on boundary");

  return (0);

}
