#include "UG2_LIB.h"

INT_ ug2_chkbedge
 (INT_ mmsg,
  INT_ mclosed,
  INT_ merr,
  INT_ mmultc,
  INT_ mreorder,
  INT_ nbedge,
  INT_ nnode,
  INT_1D * ibcibe,
  INT_2D * inibe,
  INT_1D * ierribe,
  DOUBLE_2D * x)

{

/*
 * Check and reorder a boundary edge grid.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_chkbedge.c,v 1.11 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_2D *ibeibe = NULL;
  INT_1D *ibein = NULL;
  INT_1D *iboibe = NULL;
  INT_1D *libein = NULL;
  INT_1D *mchkbe = NULL;
  INT_1D *mchkbn = NULL;

  INT_ nbepnt, nbo;
  INT_ ierr = 0;
  INT_ nbepntd = 0;

  // allocate space for error flag and temporary arrays

  ibeibe = (INT_2D *) ug_malloc (&ierr, (nbedge+1) * sizeof (INT_2D));
  iboibe = (INT_1D *) ug_malloc (&ierr, (nbedge+1) * sizeof (INT_1D));
  libein = (INT_1D *) ug_malloc (&ierr, (nnode+2) * sizeof (INT_1D));
  mchkbe = (INT_1D *) ug_malloc (&ierr, (nbedge+1) * sizeof (INT_1D));
  mchkbn = (INT_1D *) ug_malloc (&ierr, (nnode+1) * sizeof (INT_1D));

  if (ierr)
  {
    ug_error_message ("*** ERROR 100206 : unable to allocate required memory ***");
    ierr = 100206;
  }

  // check that all nodes are on a boundary edge and
  // check that all edges reference included nodes

  if (ierr == 0)
    ierr = ug2_chkbn (merr, mmsg, nbedge, nnode, inibe, mchkbn, ierribe);

  // set boundary edges attached to nodes

  if (ierr == 0)
    ierr = ug2_ibein (nbedge, &nbepntd, nnode, &nbepnt, inibe, &ibein, libein);

  // set boundary edge neighbor connectivity

  if (ierr == 0)
    ierr = ug2_ibeibe (merr, mmsg, mmultc, mreorder, nbedge, 2,
                       ibein, inibe, libein, mchkbe, ibeibe, ierribe,
                       (DOUBLE_1D *) x);

  // set boundary object map

  if (ierr == 0)
    ug2_iboibe (mmsg, nbedge, &nbo, ibeibe, iboibe);

  // reorder boundary objects if needed

  if (ierr == 0)
    ug2_ibor (mmsg, nbedge, nbo, nnode,
              ibeibe, ibein, iboibe, inibe, libein,
              x);

  // check boundary edge connectivity.

  if (ierr == 0)
    ierr = ug2_chkb (mclosed, merr, mmsg, nbedge,
                     ibcibe, ibeibe, inibe, ierribe);

  ug_free (ibeibe);
  ug_free (ibein);
  ug_free (iboibe);
  ug_free (libein);
  ug_free (mchkbe);
  ug_free (mchkbn);

  return (ierr);

}
