#include "UG2_LIB.h"

INT_ ug2_chkb
 (INT_ mclosed,
  INT_ merr,
  INT_ mmsg,
  INT_ nbedge,
  INT_1D * ibcibe,
  INT_2D * ibeibe,
  INT_2D * inibe,
  INT_1D * ierribe)
{

/*
 * Check boundary edge connectivity. Edge neighbors (ibeibe) and edge nodes
 * (inibe) are checked.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_chkb.c,v 1.16 2022/11/21 00:11:08 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  CHAR_133 Text;

  INT_ ibedge, ibedge1, ibedge2, iben1, iben2, ierr, inode2,
       jbedge, jben1, jben2, jerr, jnode2, kbedge;

  if (mmsg == 2)
  {
    snprintf (Text, sizeof(Text), "Checking           : B-Edges           =%10i", (int) nbedge);
    ug_message (Text);
  }

  ierr = -1;

  jerr = 0;

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    for (iben1 = 0; iben1 <= 1; ++iben1)
    {
      jbedge = ibeibe[ibedge][iben1];

      if (jbedge > 0)
      {
        iben2 = (iben1 == 1) ? 0 : 1;

        inode2 = inibe[ibedge][iben2];

        jben1 = 0;

        do
        {
          kbedge = ibeibe[jbedge][jben1];

          if (kbedge == ibedge)
          {
            jben2 = (jben1 == 1) ? 0 : 1;

            jnode2 = inibe[jbedge][jben2];

            ierr = (jnode2 == inode2) ? 0 : 1;
          }

          ++jben1;
        }
        while (jben1 <= 1 && ierr == -1);

        if (ierr != 0)
        {
          jerr = 1;

          if (merr == 1)
          {
            ierribe[ibedge] = -1;
            ierribe[jbedge] = -1;
          }
        }
      }
    }
  }

  if (jerr == 1)
  {
    if (merr == 1)
    {
      ug_error_message ("*** ERROR 200200 : boundary edge connectivity is not valid ***");
      return (200200);
    }

    else
    {
      ug_error_message ("*** ERROR 203 : boundary edge connectivity is not valid ***");
      return (203);
    }
  }

  if (mclosed == 1)
  {
    ierr = 0;

    for (ibedge = 1; ibedge <= nbedge; ++ibedge)
    {
      ibedge1 = ibeibe[ibedge][0];
      ibedge2 = ibeibe[ibedge][1];

      if ((ibedge1 == 0 || ibedge2 == 0) &&
          (ibcibe == NULL || CHK_TRANSP_UG2_GBC (ibcibe[ibedge]) == 0))
      {
        ierr = 1;

        ierribe[ibedge] = -1;
      }
    }

    if (ierr == 1)
    {
      if (merr == 1)
      {
        ug_error_message ("*** ERROR 200213 : open boundary curve found ***");
        return (200213);
      }

      else
      {
        ug_error_message ("*** ERROR 209 : open boundary curve found ***");
        return (209);
      }
    }
  }

  if (mmsg == 2)
    ug_message ("Checking           : Connectivity OK");

  return (0);

}
