#include "UG2_LIB.h"

INT_ ug2_chkarea
 (INT_ mmsg,
  INT_ nelem,
  INT_3D * iniel,
  INT_1D * ierriel,
  double tol,
  DOUBLE_2D * x)

{

/*
 * Check element area.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_chkarea.c,v 1.17 2022/11/21 00:11:08 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  CHAR_133 Text;

  INT_ ielem, ierr, inode1, inode2, inode3;

  double area, areatol, dx, dx1, dx2, dx211, dx212, dx311, dx312, x11, x12,
         x1max, x1min, x21, x22, x2max, x2min, x31, x32;

  if (mmsg == 2)
  {
    snprintf (Text, sizeof(Text), "Checking           : Elements          =%10i", (int) nelem);
    ug_message (Text);
  }

  if (ierriel)
  {
    for (ielem = 1; ielem <= nelem; ++ielem)
    {
      ierriel[ielem] = 0;
    }
  }

  ierr = 0;

  ielem = 1;

  do
  {
    inode1 = iniel[ielem][0];
    inode2 = iniel[ielem][1];
    inode3 = iniel[ielem][2];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x21 = x[inode2][0];
    x22 = x[inode2][1];
    x31 = x[inode3][0];
    x32 = x[inode3][1];

    dx211 = x21 - x11;
    dx212 = x22 - x12;
    dx311 = x31 - x11;
    dx312 = x32 - x12;
  
    area = dx211 * dx312 - dx212 * dx311;

    x1max = MAX (x11, x21);
    x1max = MAX (x31, x1max);
    x2max = MAX (x12, x22);
    x2max = MAX (x32, x2max);
    x1min = MIN (x11, x21);
    x1min = MIN (x31, x1min);
    x2min = MIN (x12, x22);
    x2min = MIN (x32, x2min);

    dx1 = x1max - x1min;
    dx2 = x2max - x2min;

    dx = MAX (dx1, dx2);

    areatol = tol * dx * dx;

    if (area < areatol)
    {
      ierr = 1;

      if (ierriel)
        ierriel[ielem] = -1;
    }

    ++ielem;
  }
  while (ielem <= nelem && (! ierr || ierriel));

  if (ierr)
  {
    if (mmsg != -2)
      ug_error_message ("*** ERROR 227 : found element with negative area ***");
    return (227);
  }

  if (mmsg == 2)
    ug_message ("Checking           : Area OK");

  return (0);

}
