#include "UG2_LIB.h"

INT_ ug2_chk
 (INT_ mmsg,
  INT_ mareachk,
  INT_ nelem,
  INT_ nnode,
  INT_3D * ieliel,
  INT_3D * iniel,
  double tol,
  DOUBLE_2D * x)

{

/*
 * Check element connectivity and element area. Element neighbors (ieliel) and
 * element nodes (iniel) are checked. Element area is checked for zero or
 * negative areas and the number of elements with area less than tolerance is
 * reported. 
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_chk.c,v 1.21 2022/11/21 00:11:08 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  CHAR_133 Text;

  INT_ ielem, ieln1, ieln2, ieln3, inode1, inode2, inode3, jelem, jeln1, jeln2,
       jeln3, jnode2, jnode3, kelem, mchk;

  INT_ ielnmap[3][3] =
  {
    {0, 1, 2},
    {1, 2, 0},
    {2, 0, 1}};

  double area, areatol, dc0, dx, dx1, dx2, dx211, dx212, dx311, dx312, x11, x12,
         x1max, x1min, x21, x22, x2max, x2min, x31, x32;

  dc0 = 0;

  if (mmsg == 2)
  {
    snprintf (Text, sizeof(Text), "Checking           : Nodes, Elements   =%10i%10i",
             (int) nnode, (int) nelem);
    ug_message (Text);
  }

  for (ielem = 1; ielem <= nelem; ++ielem)
  {
    for (ieln1 = 0; ieln1 <= 2; ++ieln1)
    {
      jelem = ieliel[ielem][ieln1];

      if (jelem > 0)
      {
        ieln2 = ielnmap[ieln1][1];
        ieln3 = ielnmap[ieln1][2];

        inode2 = iniel[ielem][ieln2];
        inode3 = iniel[ielem][ieln3];

        mchk = 0;

        jeln1 = 0;

        do
        {
          kelem = ieliel[jelem][jeln1];

          if (kelem == ielem)
          {
            jeln2 = ielnmap[jeln1][2];
            jeln3 = ielnmap[jeln1][1];

            jnode2 = iniel[jelem][jeln2];
            jnode3 = iniel[jelem][jeln3];

            if (jnode2 != inode2 || jnode3 != inode3)
            {
              ug_error_message ("*** ERROR 200 : element connectivity is not valid ***");
              return (200);
            }

            mchk = 1;
          }

          ++jeln1;
        }
        while (jeln1 <= 2 && mchk == 0);

        if (mchk == 0)
        {
          ug_error_message ("*** ERROR 201 : element connectivity is not valid ***");
          return (201);
        }
      }
    }
  }

  if (mmsg == 2)
    ug_message ("Checking           : Connectivity OK");

  if (mareachk == 1)
  {
    ielem = 1;

    do
    {
      inode1 = iniel[ielem][0];
      inode2 = iniel[ielem][1];
      inode3 = iniel[ielem][2];

      x11 = x[inode1][0];
      x12 = x[inode1][1];
      x21 = x[inode2][0];
      x22 = x[inode2][1];
      x31 = x[inode3][0];
      x32 = x[inode3][1];

      dx211 = x21 - x11;
      dx212 = x22 - x12;
      dx311 = x31 - x11;
      dx312 = x32 - x12;
    
      area = dx211 * dx312 - dx212 * dx311;

      x1max = MAX (x11, x21);
      x1max = MAX (x31, x1max);
      x2max = MAX (x12, x22);
      x2max = MAX (x32, x2max);
      x1min = MIN (x11, x21);
      x1min = MIN (x31, x1min);
      x2min = MIN (x12, x22);
      x2min = MIN (x32, x2min);

      dx1 = x1max - x1min;
      dx2 = x2max - x2min;

      dx = MAX (dx1, dx2);

      areatol = tol * dx * dx;

      ++ielem;
    }
    while (ielem <= nelem && area >= areatol);

    if (area < areatol)
    {
      ug_error_message ("*** ERROR 202 : found element with negative area ***");
      return (202);
    }

    if (mmsg == 2)
      ug_message ("Checking           : Area OK");
  }

  else if (mareachk == 2)
  {
    areatol = dc0;

    ielem = 1;

    do
    {
      inode1 = iniel[ielem][0];
      inode2 = iniel[ielem][1];
      inode3 = iniel[ielem][2];

      x11 = x[inode1][0];
      x12 = x[inode1][1];
      x21 = x[inode2][0];
      x22 = x[inode2][1];
      x31 = x[inode3][0];
      x32 = x[inode3][1];

      dx211 = x21 - x11;
      dx212 = x22 - x12;
      dx311 = x31 - x11;
      dx312 = x32 - x12;
    
      area = dx211 * dx312 - dx212 * dx311;

      ++ielem;
    }
    while (ielem <= nelem && area >= areatol);

    if (area < areatol)
    {
      ug_error_message ("*** ERROR 202 : found element with negative area ***");
      return (202);
    }

    if (mmsg == 2)
      ug_message ("Checking           : Area OK");
  }

  return (0);

}
