#include "UG2_LIB.h"

void ug2_bv2
 (INT_ nbedge,
  INT_ nnode,
  INT_2D * inibe,
  DOUBLE_2D * x,
  DOUBLE_2D * bv)

{

/*
 * Determine a normal vector for each boundary node.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_bv2.c,v 1.4 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ ibedge, inode, inode1, inode2;

  double bv1, bv2, dc0, dc1, w, x11, x12, x21, x22;

  dc0 = 0.0;
  dc1 = 1.0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    bv[inode][0] = dc0;
    bv[inode][1] = dc0;
  }

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    inode1 = inibe[ibedge][0];
    inode2 = inibe[ibedge][1];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x21 = x[inode2][0];
    x22 = x[inode2][1];

    bv1 = x12 - x22;
    bv2 = x21 - x11;

    w = dc1 / sqrt (bv1 * bv1 + bv2 * bv2);

    bv1 = w * bv1;
    bv2 = w * bv2;

    bv[inode1][0] = bv[inode1][0] + bv1;
    bv[inode1][1] = bv[inode1][1] + bv2;
    bv[inode2][0] = bv[inode2][0] + bv1;
    bv[inode2][1] = bv[inode2][1] + bv2;
  }

  for (inode = 1; inode <= nnode; ++inode)
  {
    bv1 = bv[inode][0];
    bv2 = bv[inode][1];

    w = dc1 / sqrt (bv1 * bv1 + bv2 * bv2);

    bv[inode][0] = w * bv1;
    bv[inode][1] = w * bv2;
  }

  return;

}
