#include "UG2_LIB.h"

INT_ ug2_bnd_nodes
 (INT_ mremove,
  INT_ *nnodeb,
  INT_ nnode,
  INT_ nbedge,
  INT_2D * inibe,
  INT_1D ** node_map,
  DOUBLE_1D * del,
  DOUBLE_1D * ds,
  DOUBLE_2D * x)

{

/*
 * Determine node index map for boundary nodes and optionally either remove
 * interior nodes from grid data or continue node index map with interior nodes
 * following boundary nodes.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_bnd_nodes.c,v 1.7 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ ibedge, ierr, inode, inode1, inode2, inodeb, inodev;

  ierr = 0;

  *node_map = (INT_1D *) ug_malloc (&ierr, (nnode+1) * sizeof (INT_1D));

  if (ierr > 0)
  {
    ug_error_message ("*** ERROR 100205 : unable to allocate required memory ***");
    return (100205);
  }

  for (inode = 1; inode <= nnode; ++inode)
  {
    (*node_map)[inode] = 0;
  }

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    inode1 = inibe[ibedge][0];
    inode2 = inibe[ibedge][1];

    (*node_map)[inode1] = 1;
    (*node_map)[inode2] = 1;
  }

  inodeb = 0;

  for (inode = 1; inode <= nnode; ++inode)
  {
    if ((*node_map)[inode] == 1)
    {
      ++inodeb;

      (*node_map)[inode] = inodeb;
    }
  }

  *nnodeb = inodeb;

  if (mremove == -1)
  {
    inodev = *nnodeb;

    for (inode = 1; inode <= nnode; ++inode)
    {
      if ((*node_map)[inode] == 0)
      {
        ++inodev;

        (*node_map)[inode] = inodev;
      }
    }
  }
  else if (mremove == 1)
  {
    for (inode = 1; inode <= nnode; ++inode)
    {
      inodeb = (*node_map)[inode];

      if (inodeb > 0)
      {
        x[inodeb][0] = x[inode][0];
        x[inodeb][1] = x[inode][1];

        if (ds != NULL)
          ds[inodeb] = ds[inode];

        if (del != NULL)
          del[inodeb] = del[inode];
      }
    }

    for (ibedge = 1; ibedge <= nbedge; ++ibedge)
    {
      inode1 = inibe[ibedge][0];
      inode2 = inibe[ibedge][1];

      inibe[ibedge][0] = (*node_map)[inode1];
      inibe[ibedge][1] = (*node_map)[inode2];
    }

    ug_free (*node_map);

    *node_map = NULL;
  }

  return (0);

}
