#include "UG2_LIB.h"

void ug2_bev
 (INT_ nbedge,
  INT_2D * inibe,
  DOUBLE_2D * x,
  DOUBLE_2D * bev)

{

/*
 * Determine a normal vector for each boundary edge.
 * 
 * UG2 LIB : Unstructured Grid - General Purpose Routine Library
 * 2D Version : $Id: ug2_bev.c,v 1.6 2020/02/15 05:24:54 marcum Exp $
 * Copyright 1994-2020, David L. Marcum
 */

  INT_ ibedge, inode1, inode2;

  double dc1, v1, v2, w, x11, x12, x21, x22;

  dc1 = 1.0;

  for (ibedge = 1; ibedge <= nbedge; ++ibedge)
  {
    inode1 = inibe[ibedge][0];
    inode2 = inibe[ibedge][1];

    x11 = x[inode1][0];
    x12 = x[inode1][1];
    x21 = x[inode2][0];
    x22 = x[inode2][1];

    v1 = x12 - x22;
    v2 = x21 - x11;

    w = dc1 / sqrt (v1 * v1 + v2 * v2);

    bev[ibedge][0] = w * v1;
    bev[ibedge][1] = w * v2;
  }

  return;

}
