#include "UG_LIB.h"

INT_ ug_write_prog_info
 (INT_ Write_Flag,
  char **prog_argv,
  int prog_argc,
  char *prog_options,
  char *prog_info)

{

/*
 * Write usage and input parameter information on a given program.
 * 
 * UG LIB : Unstructured Grid - General Purpose Routine Library
 * $Id: ug_write_prog_info.c,v 1.11 2021/02/07 01:40:46 marcum Exp $
 * Copyright 1994-2021, David L. Marcum
 */

  UG_Param_Struct *Param_Struct_Ptr = NULL;

  CHAR_UG_MAX exe_drive, exe_dir, exe_name, exe_ext, Text;

  INT_ Error_Flag;

  if (Write_Flag == 0)
    return (0);

  // get program name elements

  ug_splitpath (prog_argv[0], exe_drive, exe_dir, exe_name, exe_ext);

  // write basic usage information

  strcpy (Text, exe_name);
  strcat (Text, exe_ext);
  strcat (Text, " ");
  strcat (Text, prog_options);
  strcat (Text, " [param_options]");

  ug_message (" ");
  ug_message (Text);
  ug_message (" ");

  if (Write_Flag == 2 || Write_Flag == 4)
    ug_parse_text_string (0, prog_info);

  // return if no program parameter functions have been set

  if (ug_check_prog_param_functions() == 0)
    return (0);

  // malloc and set program parameter structure arrays

  Error_Flag = ug_set_prog_param (prog_argv, prog_argc, 0, 1, 0, &Param_Struct_Ptr);

  // write info on program input arguments

  if (Error_Flag == 0)
    Error_Flag = ug_write_param_info (Write_Flag, Param_Struct_Ptr);

  // free parameter structure

  ug_free_param (Param_Struct_Ptr);

  return (Error_Flag);
}
